// $Id: //shared_tc/com.sapall.security/630_SP_REL/src/_api_ep5/java/com/sapportals/portal/security/usermanagement/IPortalLogin.java#2 $
// $Change: 12740 $
// $Author: d036263 $
// $DateTime: 2003/10/08 10:25:09 $

package com.sapportals.portal.security.usermanagement;

import com.sap.security.toolkit.login.Credentials;
import javax.servlet.http.*;

/**
 * provide a means to authenticate users without having to
 * to know anything about the credentials needed to perform
 * the login
 * @author <a href=mailto:kai.ullrich@sap.com>Lambert Boskamp</a>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 */
public interface IPortalLogin
{
    public final static String SSOTICKET_ALIAS          = "MYSAPSSO2";
    public final static String SSOTICKET_USER_ATTRIBUTE = "$MYSAPSSO$";

    /**
     *  check whether <tt>request</tt> was issued by a user who is already
     *  logged in (i.e. for who has been authenticated before)
     *  @param request  HttpServletRequest
     *  @param response HttpServletResponse
     *  @return the currently logged in user or null
     */
    public IUser getLoggedInUser(HttpServletRequest request,
                                 HttpServletResponse response,
                                 String authScheme);

    /**
     * get a container for the credentials required to login a user; the
     * {@link Credentials} object also provides metadata about the required
     * credentials and thus about how to render a suitable logon screen.
     * Existing credentials in <tt>request</tt> may be already filled in by
     * implementations of this method
     * <b>Note:</b> This method will return a collection of the pieces of
     * information needed for logon independantly if they are already available
     * in the request or not. Consequently, this method should only be called
     * if the caller is sure that a login is necessary. To find out if a user
     * is already logged on call {@link IPortalLogin#getLoggedInUser}.
     *  @param request  HttpServletRequest
     *  @return Credentials container/metadata for credentials
     */
    public Credentials getRequiredCredentials(HttpServletRequest request, String authScheme)
    throws UserManagementException;

    /**
     * login a user. The method should be called after the user has
     * supplied the necessary login data specified by a {@link Credentials} object.
     * (See {@link IPortalLogin#getRequiredCredentials}
     *  @param request  HTTP request
     *  @param response HTTP response object
     *  @return the authenticated user object
     *  @exception UserManagementException in case authentication and/or
     *             creation of user object fail
     */
    public IUser login (HttpServletRequest request, HttpServletResponse response, String scheme)
    throws UserManagementException;

    /**
     * log out the user who issued <tt>request</tt>
     * @param req HttpServletRequest
     * @param resp HttpServletResponse
     */
    public void logout(javax.servlet.http.HttpServletRequest request,
                       javax.servlet.http.HttpServletResponse response);
    //throws UserManagementException;

    /** Returns the expiration date of the passed ticket.
     *
     */
    public java.util.Calendar getTicketExpiration (String ticket)
    throws UserManagementException;

    /**
     * Tells the authenticator the logical system that's used as
     * ticket reference system
     */
    public void setR3ReferenceSystem (String system);

    /** Gets from the authenticator which logical system is
     *  used as ticket reference system
     */

     public String getR3ReferenceSystem ();

     public String getSuperAdminToken ();
}
