package com.sapportals.portal.security.usermanagement;

/**
 * This class provides functionality to change user information.
 *
 * @author  Alexander Primbs
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 *
 */

public interface IModifyUser extends com.sapportals.portal.security.usermanagement.IModifyUMPrincipal,
                                      com.sapportals.portal.security.usermanagement.IUser
{


	/**
	 *  Sets the address city.
	 *
	 *@param  value  The new City value
         *@throws UserManagementException if an error occurs
	 */
	public void setCity( String value ) throws UserManagementException;

	/**
	 *  Sets the address country.
	 *
	 *@param  value  The new Country value
         *@throws UserManagementException if an error occurs
	 */
	public void setCountry( String value ) throws UserManagementException;

	/**
	 *  Sets the Currency.
	 *
	 *@param  value  The new Currency value
         *@throws UserManagementException if an error occurs
	 */
	public void setCurrency( String value ) throws UserManagementException;

	/**
	 *  Sets the department of the user. Example : Application Dev., Sales...
	 *
	 *@param  value  The new Department value
         *@throws UserManagementException if an error occurs
	 */
	public void setDepartment( String value ) throws UserManagementException;

	/**
	 *  Sets the email address.
	 *
	 *@param  value  The new Email value
         *@deprecated user setEmail(String[] value) instead
	 */
	public void setEmail( String value ) throws UserManagementException;

	/**
	 *  Sets the email addresses
	 *
	 *@param  value  The new Email values
         *@throws UserManagementException if an error occurs
	 */
	public void setEmail( String[] value ) throws UserManagementException;

	/**
	 *  Sets the fax.
	 *
	 *@param  value  The new Fax value
         *@deprecated use setFax(String[] value) instead
	 */
	public void setFax( String value ) throws UserManagementException;

	/**
	 *  Sets the fax.
	 *
	 *@param  value  The new Fax value
	 *@throws UserManagementException if an error occurs
	 */
	public void setFax( String[] value ) throws UserManagementException;

	/**
	 *  Sets the First name of the user.
	 *
	 *@param  value  The new FirstName value
         *@throws UserManagementException if an error occurs
	 */
	public void setFirstName( String value ) throws UserManagementException;

	/**
	 *  Sets the Last name of the user.
	 *
	 *@param  value  The new LastName value
         *@throws UserManagementException if an error occurs
	 */
	public void setLastName( String value ) throws UserManagementException;

	/**
	 *  Same as setTitle().
	 *
	 *@param  value  The new Position value
         *@throws UserManagementException if an error occurs
	 */
	public void setPosition( String value ) throws UserManagementException;

	/**
	 *  Sets the language.
	 *
	 *@param  value  The new PreferredLanguage value
         *@throws UserManagementException if an error occurs
	 */
	public void setPreferredLanguage( String value ) throws UserManagementException;

	/**
	 *  Sets the address state
	 *
	 *@param  value  The new State value
         *@throws UserManagementException if an error occurs
	 */
	public void setState( String value ) throws UserManagementException;

	/**
	 *  Sets the street address.
	 *
	 *@param  value  The new StreetAddress value
         *@throws UserManagementException if an error occurs
	 */
	public void setStreetAddress( String value ) throws UserManagementException;

	/**
	 *  Sets the telephone number
	 *
	 *@param  value  The new Telephone value
         *@deprecated use setTelephone(String[] value) instead
	 */
	public void setTelephone( String value ) throws UserManagementException;

	/**
	 *  Sets the telephone number
	 *
	 *@param  value  The new Telephone value
	 *@throws UserManagementException if an exception occurs
	 */
	public void setTelephone( String[] value ) throws UserManagementException;

	/**
	 *  Sets the mobile telephone number.
	 *
	 *@param  value  The new Mobile value
         *@deprecated: use setMobile(String[] value) instead
	 */
	public void setMobile( String value ) throws UserManagementException;

	/**
	 *  Sets the mobile telephone numbers.
	 *
	 *@param  value  The new Mobile value
	 *@throws UserManagementException if an error occurs
	 */
	public void setMobile( String[] value ) throws UserManagementException;

	/**
	 *  Sets the timezone . Example PST, CST...
	 *
	 *@param  value  The new TimeZone value
         *@throws UserManagementException if an error occurs
	 */
	public void setTimeZone( String value ) throws UserManagementException;

	/**
	 *  Sets the job title.
	 *
	 *@param  value  The new Title value
         *@throws UserManagementException if an error occurs
	 */
	public void setTitle( String value ) throws UserManagementException;

	/**
	 *  Sets the address zip code.
	 *
	 *@param  value  The new Zip value
         *@throws UserManagementException if an error occurs
	 */
	public void setZip( String value ) throws UserManagementException;

	/**
	 * sets the value for a given locale.
	 *
         * If attribute locale is not mapped as an attribute in configuration_ldap.xml
         * file the locale attribute is fetched
         * {@link IUser#getLocale()}.<br>
         * and stored in the portal LDAP.
         *
	 *@param  locale  The new Locale value
         *@throws UserManagementException if an error occurs
         */
	public void setLocale( java.util.Locale locale ) throws UserManagementException;

        /**
         * Sets the user's DateFormat.
         *@throws UserManagementException if an error occurs
         */
        public void setDateFormat(String dateFormat) throws UserManagementException;

	/**
	 *  Sets the salutation Mr., Mrs., Ms. etc.
	 *
	 *@param  value  The new Salutation value
         *@throws UserManagementException if an error occurs
	 */
	public void setSalutation( String value ) throws UserManagementException;

        /**
         * Sets the name of the company this user belongs to.
         */
        public void setCompanyName(String value ) throws UserManagementException;

        /**
         * Set the user's post office box
         */
        public void setPobox(String value ) throws UserManagementException;

        /**
         * Set the user's accessibility level
         * used for Screen Reader Support
         */
        public void setAccessibilityLevel(int value ) throws UserManagementException;
}
