package com.sapportals.portal.security.usermanagement;

/**
 * This interface provides functionality to read and write information of registered principals.
 *
 * @author  Alexander Primbs
 * @version 1.0
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 */

public interface IModifyUMPrincipal
{
    /**
     * Check if the object has been modified
     *
     * @return true if any of the set method on this object is called.
     */
    public boolean isModified();

    /**
     * generic set method
     *
     * @param key   unique identifier for the values
     * @param value String array of values
     * @exception	UserManagementException
     */
    public void setValuesForKey(String key, String[] value)
                throws UserManagementException;

    /**
     * generic set method
     *
     * @param namespace   unique identifier for the namespace
     * @param key   unique identifier for the values
     * @param value String array of values
     * @exception	UserManagementException
     */
    public void setValuesForKey(String namespace, String key, String[] value)
                throws UserManagementException;


    /**
     * method to save the modified values to the data store
     *
     * @exception	UserManagementException
     */
    public void save () throws UserManagementException;

    /**
     * method to get a handler for modifying user mapping data
     */
    public IModifyLogonDataBroker getMappingInfoModifier();

    /**
     * Assign this group as child of the parent-group.
     *
     * @param	gid       unique id of the parent group
     * @exception	UserManagementException

    public void assignParentGroup(String gid) throws UserManagementException;
     */
    /**
     * Unassign this group as child of the parent-group.
     *
     * @param	gid       unique id of the parent group
     * @exception	UserManagementException

    public void unassignParentGroup(String gid) throws UserManagementException;
     */

    /**
     * Assign user to a role .
     * @param	rid	unique id of role, to which the user will be assigned
     */
    public void assignRole(String rid) throws UserManagementException;

    /**
     * Unassign user from this role .
     * @param	String	role id of role, from which the user will be unassigned
     */
    public void unassignRole(String rid) throws UserManagementException;

    /**
     * Sets the displayName of this principal.
     *
     * @exception UserManagementException if the displayName could not be set
     *
     */
    public void setDisplayName(String displayName) throws UserManagementException;

    /**
     * Sets the description of this principal.
     *
     * @exception UserManagementException if the description could not be set
     *
     */
    public void setDescription(String description) throws UserManagementException;


}