package com.sapportals.portal.security.usermanagement;

/**
 * This class provides functionality to change role information.
 *
 * @author  Alexander Primbs
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 *
 */

public interface IModifyRole extends com.sapportals.portal.security.usermanagement.IModifyUMPrincipal,
                                     com.sapportals.portal.security.usermanagement.IRole
{
  /**
   * add a user to this role
   *
   * @param	uid       unique id of the user, who will be added to this role
   * @exception	UserManagementException
   */
  public void addUser(String uid) throws UserManagementException;

  /**
   * remove a user from this role
   *
   * @param	uid       unique id of the user, who will be removed from this role
   * @exception	UserManagementException
   */
  public void removeUser(String uid) throws UserManagementException;

  /**
   * add a group to this role
   *
   * @param	rid       unique id of the role, which will be added to this role
   * @exception	UserManagementException
   */
  public void addGroup(String rid) throws UserManagementException;

  /**
   * remove a group from this role
   *
   * @param	rid       unique id of the role, which will be removed from this role
   * @exception	UserManagementException
   */
  public void removeGroup(String rid) throws UserManagementException;

}