package com.sapportals.portal.security.usermanagement;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.HashMap;

/**
 * This class provides functionality to change information which is needed to
 * enrich connections with additional
 * information.
 *
 * Copyright (c) SAP Portals Europe GmbH 2001
 * @author        Steffen Huester<br>
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 */

public interface IModifyLogonDataBroker
{
    /**
     * Constant for the request parameter which is set to true in the form generated
     * via sendLogonScreen
     * @deprecated
     */
    public static final String REQUESTPARAM_SAVE = "saveMappingInfo";

    /**
     *  This method sends a login screen to the given response. The screen contains
     *  form fields according to the required logon data of the given AbstractBackendConnection.
     *  The form will be posted to the URI of the given request.
     *  <p>
     *
     * @param abc       the backend connection to build the screen for
     * @param request   the request object for this request
     * @param response  the response object for this response
     * @throws  IOException if writing to the response fails
     * @throws  IllegalStateException if the response has already been committed
     *
     * @deprecated
     */
    public void    sendLogonScreen      (AbstractBackendConnection abc, HttpServletRequest request, HttpServletResponse response)
      throws java.io.IOException;

    /**
     *  This method sends a login screen to the given writer. The screen contains
     *  form fields according to the required logon data of the given AbstractBackendConnection.
     *  The form will be posted to the URI of the given request.
     *  <p>
     *
     * @param abc     the backend connection to build the screen for
     * @param request the request object for this request
     * @param out     the object to write the HTML code to
     *
     * @deprecated
     */
    public void    sendLogonScreen      (AbstractBackendConnection abc, HttpServletRequest request, PrintWriter out);

    /**
     *  This method saves the logon data contained in the given request. These request parameters
     *  must match with the required data of the given backend connection (credential aliases).
     *  This method can be used to store data from a form created via sendLogonScreen method.
     *  <p>
     *
     * @param abc     the backend connection
     * @param request the request object containing the logon parameters
     * @throws UserManagementException if saving fails
     */
    public void    saveLogonData      (AbstractBackendConnection abc, HttpServletRequest request)
      throws UserManagementException;

    /**
     *  This method saves the logon data contained in the given HashMap. These  parameters
     *  must match with the required data of the given backend connection (credential aliases).
     *
     * @param abc       the backend connection
     * @param logonData the HashMap containing the logon parameters
     * @throws UserManagementException if saving fails
     */
    public void    saveLogonData      (AbstractBackendConnection abc, HashMap logonData)
      throws UserManagementException;

    /**
     *  This method deletes the logon data in the given application string.
     *  The complete entry containing the application specific attributes will be removed
     *  from the repository. The application to delete is added to a list "applications to delete"
     *  When calling the save() method the application is removed permanently.
     *
     * @param applicationname name of the application to be deleted
     * @throws UserManagementException if saving fails
     */
    public void    deleteLogonData      (String applicationname)
      throws UserManagementException;

}