package com.sapportals.portal.security.usermanagement;

/**
 * This class provides functionality to enrich connections with additional
 * information.
 * @version $Revision: #3 $ <BR>
 * @deprecated  This interface has been replaced by 
 * interfaces <code>com.sap.security.api.umap.IUserMapping</code> and
 * <code>com.sap.security.api.umap.IUserMappingData</code> which contains
 * <code>enrich</code> methods and additional functionality.
 * These interfaces are part of the User Management Engine(UME) APIs.
 * The interfaces  
 * can be accessed via 
 * <br><code>com.sap.security.api.UMFactory.getUserMapping()</code>
 * and
 * <br><code>com.sap.security.api.UMFactory.getUserMapping().getUserMappingData(ISystemLandscapeObject system, IPrincipal pri)</code>
 * In order to get a 
 * <br><code>com.sap.security.api.umap.system.ISystemLandscapeObject</code>
 * use <code>com.sapportals.portal.prt.service.usermapping.IUserMappingService</code>
 * from EP6 portal. 
 *
 */


public interface ILogonDataBroker
{
    /** function to call prior to instantiation of a JCO client
     *  If a ticket is present in the servlet request it will be added to
     *  the JCO properties. This call is for systems that accept ticket or
     *  certificate logon.
     *  <p>
     *
     *  @param request servlet request
     *  @param JCOProps Properties that have been assembled in order to
     *                  instantiate a JCO.client object
     *  @param system   System in the system landscape that corresponds
     *                  to this jco Destination (only evaluated if logonMethod==UIDPW)
     *  @param logonMethod logon method used for this connection. Values are
     *                  maintained in jcodestination.xml.
     * 
     */
    public void enrich  (javax.servlet.http.HttpServletRequest request, java.util.Properties JCOProps, String system, String logonMethod);

    /** function to enrich an HttpURLConnection object. A ticket (if present)
     *  will be added to the Cookies of the http connection.
     *  This is call is also for systems that accept ticket or certificate
     *  logon.
     *  <p>
     *
     *  @param request    servlet request
     *  @param connection http connection
     */
    public void    enrich               (javax.servlet.http.HttpServletRequest request, java.net.HttpURLConnection connection);

    /** function to enrich an arbitrary backend connection. The required logon data
     *  for this connection will be looked up and set in the connection if present.
     *  <p>
     *
     *  @param abc the backend connection to enrich
     *  @return true, if the connection was enriched successfully, i.e. mapping data was found;
     *    false otherwise
     */
    public boolean enrich               (AbstractBackendConnection abc);
}