package com.sapportals.portal.security.usermanagement;

import java.util.Properties;
import javax.servlet.http.*;

/**
 * This class provides functionality to initialize and check information about
 * the credentials needed to login.
 * Copyright (c) SAP Portals Europe GmbH 2001
 * @author       Kai Ullrich
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 *
 */

public interface IInitialLogin
{
    /** Initializes the this class. A properties object will be provided.
     *  This property object is populated from the global properties object
     *  that configures the PRT. All properties that match the namespace
     *  of this login handler are copied into the <i>conf</i> properties object
     *  passed to this method.
     *  The namespaces are composed: authscheme.<authscheme-name>
     *  Built-in authscheme is "default".
     *  Example:
     *  The global properties file contains entries:
     *  <PRE>
     *  authscheme.myauthscheme.user.type     = text
     *  authscheme.myauthscheme.password.type = password
     *  authscheme.myauthscheme.class         = <mypackage>.<myclass> #implementing IInitialLogin
     *  authscheme.myauthscheme.myprop1       = my preferred socker club
     *  authscheme.myauthscheme.myprop2       = prop2value
     *  ...
     *  </PRE>
     *  The properties object passed to init will contain the properties
     *  user.type = text
     *  user.password = password
     *  class = <mypackage>.<myclass>
     *  myprop1 = my preferred socker club
     *  myprop2 = prop2value
     *
     *  (The first three properties are necessary for the PortalLoginHandler, myclass
     *  will probably ignore them).
     *  @param conf Properties object as explained above
     */
    public void   initialize    (Properties conf);

    /** The only purpose of this method is to check whether
     *  the supplied logon data is valid.
     *  @param request The login request to be processed
     *  @param response http response. Can be used to set cookies, etc.
     *  @return the authenticated user name
     */
    public String doLogin (HttpServletRequest request, HttpServletResponse response) throws UserManagementException;
}