package com.sapportals.portal.security.usermanagement;


/**
 * This interface for a groupfactory provides functionality to get group objects by providing required information.
 *
 * @author  Alexander Primbs
 * @version $Revision: #3 $ <BR>
 * @deprecated <I>This interface has been
 * replaced by interface <code>com.sap.security.api.IGroupFactory</code> which is 
 * part of the User Management Engine(UME) APIs.</I>
 *
 */

public interface IGroupFactory
{
        public static final int FULL     = 0;
        public static final int MINIMUM  = 1;
        public static final int TRUSTED  = 2;

    /**
     * Creates a new group.
     *
     * @param		group		the group object, which will be created
     * @exception	UserManagementException

    public void createGroup(IGroup group) throws UserManagementException;
     */
    /**
     * Deletes a group
     *
     * @param		group		the group object, which will be deleted
     * @exception	UserManagementException

    public void deleteGroup(IGroup group) throws UserManagementException;
     */
    /**
     * Returns a group object for an existing group.
     *
     * @param	gid	group id of the group
     * @return	IGroup	a group object implementing IGroup
         * <code>null</code> if no groups are available
     * @exception		UserManagementException
     */
    public IGroup getGroup(String gid) throws UserManagementException;

        /**
         * Returns a group object for a given group id
         *
         * @param	rid		id of the group
         * @param	mode    following modes are allowed:
         *   FULL   : all the data necessary for this group object is contained in this object. The object
         *            representing the IGroup interface contains all information fetched from the persistence
         *            layer
         *   MINIMUM: it is checked that the IGroup object exists in the persistence layer and only contains
         *            minimum set of data. If additional data is needed which is transparent to the application
         *            there is a round trip necessary to fetch additional data.
         *   TRUSTED: the group object returned is not guaranteed to exist on the persistence layer
         *            If this option is chosen, it is not checked if the group object exists in the data store.
         *            This means, you will get an IGroup object which does not belong to your data store population.
         *            For such an object it only makes sense to call following interfaces of IGroup method:
         *            @link IUMPrincipal#equals(IUMPrincipal principal)
         *            @link IUMPrincipal#getType();
         *            All other methods will return a @link UserManagementRuntimeException if this group does
         *            not exist
         *
         *
         * @return	IGroup	a group object implementing IGroup
         *
         * @exception		UserManagementException
         * @deprecated
         */
        public IGroup getGroup(String uid, int mode)
                throws UserManagementException;

    /**
     *  Returns a IModifyGroup object to be used to modify a group.
     * <p>
     * Call method save of IModifyGroup to update the group information.
     *
     *@param  gid	gid of Group that should be modified
     *@return	IModifyGroup to modify the group
         *<code>null</code> if group does not exist
     *@exception  UserManagementException
     */
    public IModifyGroup getModifyGroup(String gid) throws UserManagementException;

    /**
     *  Returns a IModifyGroup object to be used to modify a group.
     * <p>
     * Call method save of IModifyGroup to update the group information.
     *
     *@param  IGroup group that should be modified
     *@return	IModifyGroup to modify the group
         *<code>null</code> if group does not exist
     *@exception  UserManagementException
     */
    public IModifyGroup getModifyGroup(IGroup group) throws UserManagementException;

    /**
     *  Finds all groups matching specific ISearchGroup information. <p>
     *
     *  To set the search criteria, create a new ISearchGroup and set
     *  the respective group information.
     *
     * @param  searchdata		ISearchGroup
     * @param	maxcount	maximal number of entries (0 for all)
     * @return	Array of group objects implementing IGroup
         * @exception  UserManagementException
     */
    public String[] findGroups(ISearchGroup searchdata, int maxcount) throws UserManagementException;

    /**
     *  Returns an ISearchGroup object to be used to specify query attributes
     * <p>
         * ISearchGroup only contains attributes which will be queried
     *
     *@return     ISearchGroup without attributes
         *
     *@exception  UserManagementException
     */
    public ISearchGroup getSearchGroup() throws UserManagementException;

    /**
     * Gets the user object of the new user management interface UME
     */
     public com.sap.security.api.IGroup getUMEGroup(com.sapportals.portal.security.usermanagement.IGroup ep5Group)
            throws com.sap.security.api.NoSuchGroupException;

    /**
     * Gets the EP5.0 user object of the new user management interface UME
     */
     public com.sapportals.portal.security.usermanagement.IGroup getEP5Group(com.sap.security.api.IGroup umeGroup)
        throws UserManagementException;

}