package com.sapportals.portal.security.usermanagement;

/**
 * This interface provides functionality to read information of registered groups.
 *
 * @author  Alexander Primbs
 * @version $Revision: #3 $ <BR>
 * @deprecated  As of UME 4.0, replaced by interface com.sap.security.api.IGroup
 *
 *
 */

public interface IGroup extends com.sapportals.portal.security.usermanagement.IUMPrincipal
{
		/**
		 * @deprecated use com.sap.security.api.IGroupFactory.EVERYONE or 
		 * com.sap.security.api.IGroupFactory.EVERYONE_UNIQUEID instead
		 */
        public final static String EVERYBODY = "everybody";
        /**
         * Returns all Users belonging to this group
         *
         * @return Stringarray of unique user ID's.
         * @deprecated
         */
        public String[] getUsers();

        /**
         * Returns all direct children Groups belonging to this group
         *
         * @return Array of String or null if no children exist
         * @deprecated
         */
        public String[] getChildGroups();

        /**
         * Returns all direct predecessor Groups belonging to this group
         *
         * @return Array of String or null if no parent exists
         * @deprecated
         */
        public String[] getParentGroups();

        /**
         * Checks wheter this IGroup object contains a user with given uid
         *
         * @param uid   unique ID of the user, which will be checked, if it belongs to the group
         * @return	true if user belongs to this group
         *              false otherwise
         * @see		#getUsers()
         *
         */
        public boolean containsUser(String uid);
        public boolean containsGroup(String uid);
        /**
         * Returns all child Groups which are members this group
         *
         * @return Array of String or null if no parent exists
         */
        public String[] getAllChildGroups();
        /**
         * Returns all direct child Groups which are members this group
         *
         * @return Array of String or null if no parent exists
         */
        public String[] getDirectChildGroups();
        /**
         * Returns all child Users who are members this group
         *
         * @return Array of String or null if no parent exists
         */
        public String[] getAllChildUsers();
        /**
         * Returns direct child Users who are members this group
         *
         * @return Array of String or null if no parent exists
         */
        public String[] getDirectChildUsers();
        /**
         * Checks if the group belongs to the role roleID
         * returns true if the group is directly or indirectly (via Group membership)
         * assigned to this role. Note: A change in the assignment of a group to a role
         * (see com.sapportals.portal.security.usermanagement.IMofifyRole: addGroup(groupID), removeGroup(groupID) ) is not
         * automatically recognized. Use IGroup.refresh() to update a outdated instance.
         *
         * @param roleID the ID of the role
         */
        public boolean isInRole(String roleID);

        /**
         * Gets the group object of the new user management interface UME
         */
        public com.sap.security.api.IGroup getUMEGroup();
}