package com.sapportals.portal.security.usermanagement;

import java.util.HashMap;
import java.util.Properties;
import com.sap.security.toolkit.login.Credentials ;

/**
 *               enable usermapping for arbitrary backend systems
 * Copyright (c) SAP Portals Europe GmbH 2001
 * @author       <a href="mailto:kai.ullrich@sap.com">Kai Ullrich</a>
 * @version $Revision: #2 $ <BR>
 * @deprecated  As of UME 4.0, replaced by classes of package com.sap.security.api
 */

public abstract class AbstractBackendConnection
{
  /**
   *  Constant for the parameter name of the mapped user attribute
   */
  public static final String MAPPINGPARAM_USER        = "user";

  /**
   *  Constant for the parameter name of the mapped password attribute
   */
  public static final String MAPPINGPARAM_PASSWORD    = "mappedpassword";

  /**
   *  Get default credentials (username and password). This method
   *  is called if the backend connection does not provide custom credentials, i.e.
   *  {@see getRequiredData()} returns null
   *
   *  @return default credentials (username and password)
   */
  public static final Credentials getDefaultCredentials()
  {
    Properties props = new Properties();

    // set properties for user entry
    props.setProperty(MAPPINGPARAM_USER + ".Type", "text");
    props.setProperty(MAPPINGPARAM_USER + ".Prompt", "User");
    props.setProperty(MAPPINGPARAM_USER + ".Index", "1");

    // set properties for mappedpassword entry
    props.setProperty(MAPPINGPARAM_PASSWORD + ".Type", "password");
    props.setProperty(MAPPINGPARAM_PASSWORD + ".Prompt", "Password");
    props.setProperty(MAPPINGPARAM_PASSWORD + ".Index", "2");

    return new Credentials ("", props, "");
  }

  /**
   *  Subclasses have to overwrite this method to realize mapping for custom
   *  logon parameters. In this baseclass, the method returns the default credentials.
   *
   *  @return a Credentials object specifying the required logon parameters for this connection
   */
  public Credentials getRequiredData ()
  {
    // return default credentials
    return AbstractBackendConnection.getDefaultCredentials();
  }

  /**
   *  This method is called by {@link ILogonDataBroker} to set the logon data for this
   *  connection. The keys of the returned HashMap are equal to the aliases of the Credentials object
   *  returned by {@see getRequiredData()}, if specified, otherwise the names.
   *
   *  @throws UserManagementRuntimeException if the specified HashMap does not contain all required parameters
   */
  public abstract void  setLogonData (HashMap env);

  /**
   *  Get the logical system name for this backend connection. This
   *  name must be unique.
   *
   *  @return the logical system name for this backend connection
   */
  public abstract String getRemoteApplication ();

  /**
   *  Connect to the backend system
   */
  public abstract void  connect      ()
                  throws UserManagementException ;

  /**
   *  Close the connection
   */
  public abstract void  logoff       ();
}