/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

/* Note:
 * This is based on technique developed by Jon Kern eons ago.
 */

package util;

import java.io.Serializable;

/**
 * This is a helper class used to return the database index and the user-
 * friendly "name" string for a given object in the database table. It is very
 * useful when doing "shallow retrieves" of complex objects to populate, for
 * example, a drop-down list box of choices.
 */
public class IDString implements Serializable
{
    /**
     * Object ID number.
     * Defaults to 0 for a new object not yet in the database.
     * This '0' is used by persistence mecahnism to know whether an object
     * is new, and hance needs to be inserted, or if it is already in existence
     * (a non-zero ID), and needs to be updated.
     */
	int id = 0;

	 /**
	  * This is the Object's name.
	  */
	 String text = "";

		public int attribute1;

	public IDString()
	{
		this(0, "");
	}

	public IDString(int id, String text)
	{
		this.id = id;
		this.text = text;
	}

	public IDString(IDString data)
	{
		this(data.id, data.text);
	}

	public Object clone()
	{
		return new IDString(id, text);
	}

	public boolean equals(Object obj)
	{
		boolean retVal = false;
		
		if(this == obj)
		{
			retVal = true;
		}
		else if(obj instanceof IDString)
		{
			IDString item = (IDString)obj;
			if(this.id == item.id && this.text.equals(item.text))
			{
			retVal = true;
			}
		}
	
		return retVal;
	}  // END equals()

	public String toString()
	{
		return text;
	}

	public void setID(int value)
	{
		id = value;
	}
	
	public int getID()
	{
		return id;
	}

	public void setText(String value)
	{
		text = value;
	}
	
	public String getText()
	{
		return text;
	}
}  // ENDCLASS

