/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package user_interface;

import java.text.NumberFormat;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import problem_domain.CashSale;
import problem_domain.CashSaleDetail;
import problem_domain.ProductDesc;

// ENDCLASS POSFrame


/**
 * Create a model of the data. NOTE: We could have built our own local
 * vector to store the sale detail objects, but we are using the GUI
 * object's own instance of a CashSale object to access the information
 * pertaining to its collection of SaleDetails.
 */
public class TableDataModel extends AbstractTableModel{

    public TableDataModel(NumberFormat currencyFormat, CashSale currentSale){
        this.currencyFormat = currencyFormat;
        this.currentSale = currentSale;
    }
        /** Problem Domain Object */
    private CashSale currentSale;

    private NumberFormat currencyFormat;
    /** Sale Detail Table Column Header */
	private final String[] colNames = {"Item", "Name", "Unit", "Qty", "Price"};

    // These 3 methods always need to be implemented.
    public int getColumnCount()
    {
        return colNames.length;
    }

    public int getRowCount()
    {
        Vector detailList = currentSale.getDetailList();
        if (detailList != null)
        {
            return detailList.size();
        }
        else
        {
            return 0;
        }
    } // END getRowCount()


    public Object getValueAt(int row, int col)
    {
        // First get the detail item "row"
        CashSaleDetail detail =
            (CashSaleDetail)currentSale.getDetailList().elementAt(row);
        ProductDesc product = detail.getProductDesc();

		// Lets table auto-format native data types
        Object data;

        // Now do the grunt work to map a column to an attribute
        // {"Item", "Name", "Unit", "Qty", "Price"};
        switch (col)
        {
            case 0: // Item
                data = product.getItemNumber();
                break;
            case 1: // Name
                data = product.getName();
                break;
            case 2: // Unit Price
                data = currencyFormat.format(product.getPrice());
                break;
            case 3: // Qty
                data = new Integer(detail.getQty());
                break;
            case 4: // Price
                data = currencyFormat.format(product.calcPriceForQty(detail.getQty()));
                break;
            default:
                data = "Unknown!";
                break;
        } // ENDSWITCH
        return data;
    } // END getValueAt()

    // The default implementations of these methods in
    // AbstractTableModel would work, but we can refine them.
    public String getColumnName(int column)
    {
        return colNames[column];
    }

    // Don't allow any editing
    public boolean isCellEditable(int row, int col)
    {
        return false;
    }

    public void setValueAt(Object aValue, int row, int column)
    {
        //
        // data[row][column] = aValue;
    }

    /** Update the table with the changed data model. */
    public void dataChanged(int changeType, int index)
    {
        if (changeType == POSFrame.ADDED_DETAIL)
        {
            // Paint the part of the table that changed
            fireTableDataChanged();
            //fireTableRowsInserted(index, index);
        }
        else
        {
            // Use this to redo the whole table
            // since all rows are effectively deleted!
            fireTableDataChanged();
        }
    } // END dataChanged()

    /**
     * JTable uses this method to determine the default renderer/ editor
     * for each cell to improve the display.
     */
    public Class getColumnClass(int c)
    {
        return getValueAt(0, c).getClass();
    }
};


