/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

/* Note:
 * This is based on a technique used eons ago. Developed by Jon Kern
 * and his co-workers at Lightship, primarily Ed Carr.
 */

package server;

import java.sql.*;
import java.text.*;
import java.util.*;
import util.*;

/**
 * This is simply the start on a useful Helper-style class...
 * @url element://model:project::PurchaseTransaction/jdt:e_class:src:data_management.SaleDM
 */
public abstract class Database
{
  private Connection connection = null;
  private String tableName = "";

  protected Database(Connection connection, String tableName)
  {
    this.connection = connection;
    this.tableName = tableName;
  }

  protected Vector getIDStringList() throws SQLException
  {
    return getIDStringList("ID", "Name", null);
  }

  protected Vector getIDStringList(String idColumnName, String textColumnName) throws SQLException
  {
    return getIDStringList(idColumnName, textColumnName, null);
  }

  protected Vector getIDStringList(String idColumnName, String textColumnName,
    String whereClause) throws SQLException
  {
    Vector list = new Vector();

    String query = "SELECT " + idColumnName + ", " + textColumnName + " FROM " +
                   tableName;
    if(whereClause != null && !whereClause.trim().equals(""))
    {
      query = query + " WHERE " + whereClause;
    }

    Statement s = connection.createStatement();
    ResultSet rs = s.executeQuery(query);
    boolean isOk = rs.next();
    while(isOk)
    {
      IDString data = getIDString(rs, idColumnName, textColumnName);

      if(data != null)
      {
        list.addElement(data);
      }
      isOk = rs.next();
    }

    s.close();

    return list;
  }

  protected CustResultSet select(String query) throws SQLException
  {
    Statement s = connection.createStatement();
    CustResultSet rs = new CustResultSet(s.executeQuery(query));

    return rs;
  }

  protected Vector getStringList(String textColumnName, boolean selectDistinct) throws SQLException
  {
    return getStringList(textColumnName, null, selectDistinct);
  }

  protected Vector getStringList(String textColumnName, String whereClause, boolean selectDistinct) throws SQLException
  {
    Vector list = new Vector();

    String query = "SELECT ";
    if(selectDistinct)
    {
      query = query + "DISTINCT ";
    }
    query = query + textColumnName + " FROM " + tableName;

    if(whereClause != null && !whereClause.trim().equals(""))
    {
      query = query + " WHERE " + whereClause;
    }

    Statement s = connection.createStatement();
    ResultSet rs = s.executeQuery(query);
    boolean isOk = rs.next();
    while(isOk)
    {
      String text = rs.getString(textColumnName);

      if(text != null)
      {
        list.addElement(text);
      }
      isOk = rs.next();
    }

    s.close();

    return list;
  }

  protected void delete(int id) throws SQLException
  {
    delete("ID = " + id);
  }

  protected void delete(String whereClause) throws SQLException
  {
    String query = "DELETE FROM " + tableName;
    if(whereClause != null && !whereClause.trim().equals(""))
    {
      query = query + " WHERE " + whereClause;
    }

    Statement s = connection.createStatement();
    s.executeUpdate(query);
    s.close();
  }

  protected void executeUpdate(String query) throws SQLException
  {
    Statement s = connection.createStatement();
    s.executeUpdate(query);
    s.close();
  }

  protected abstract Object getData(CustResultSet rs) throws SQLException;

  protected Vector selectList(String[] columnNames, String whereClause) throws SQLException
  {
    return selectList(columnNames, whereClause, null);
  }

  protected Vector selectList(String[] columnNames, String whereClause, String orderBy) throws SQLException
  {
    Vector list = new Vector();

    String query = "SELECT ";
    query = query + getColumnNameString(columnNames);
    query = query + " FROM " + tableName;
    if(whereClause != null && !whereClause.trim().equals(""))
    {
      query = query + " WHERE " + whereClause;
    }

    if(orderBy != null && !orderBy.trim().equals(""))
    {
      query = query + " ORDER BY " + orderBy;
    }

    Statement s = connection.createStatement();
    ResultSet rs = s.executeQuery(query);
    boolean isOk = rs.next();
    while(isOk)
    {
      list.addElement(getData(new CustResultSet(rs)));
      isOk = rs.next();
    }

    s.close();

    return list;
  }

  protected Object get(String[] columnNames, int id) throws SQLException
  {
    return get(columnNames, "ID = " + id);
  }

  protected Object get(String[] columnNames, String whereClause) throws SQLException
  {
    Object data = null;

    String query = "SELECT ";
    query = query + getColumnNameString(columnNames);
    query = query + " FROM " + tableName;
    if(whereClause != null && !whereClause.trim().equals(""))
    {
      query = query + " WHERE " + whereClause;
    }

    Statement s = connection.createStatement();
    ResultSet rs = s.executeQuery(query);
    boolean isOk = rs.next();
    if(isOk)
    {
      data = getData(new CustResultSet(rs));
      isOk = rs.next();
      if(isOk)
      {
        // Found more than one object with this criteria.
        data = null;

        // throw exception.
        throw new RuntimeException("Returned more than one row!");
      }
    }

    s.close();

    return data;
  }

  protected IDString getIDString(int id) throws SQLException
  {
    return getIDString("ID", "Name", "ID = " + id);
  }

  protected IDString getIDString(String idColumn, String textColumn, String whereClause) throws SQLException
  {
    IDString data = null;
    String query = "SELECT " + idColumn + ", " + textColumn + " FROM " + tableName;
    if(whereClause != null && !whereClause.trim().equals(""))
    {
      query = query + " WHERE " + whereClause;
    }

    Statement s = connection.createStatement();
    ResultSet rs = s.executeQuery(query);

    if(rs.next())
    {
      data = getIDString(rs, idColumn, textColumn);

      if(rs.next())
      {
        data = null;
      }
    }

    s.close();

    return data;
  }

  protected void insert(String[] columnNames, String[] columnValues) throws SQLException
  {
    if(columnNames.length != columnValues.length)
    {
      // throw exception
    }
    String query = "INSERT INTO " + tableName;
    query = query + " (" + getColumnNameString(columnNames) + ") VALUES (";
    query = query + getColumnNameString(columnValues) + ")";
System.out.println( query );
    Statement s = connection.createStatement();
    s.executeUpdate(query);
    s.close();
  }

  protected void update(String[] columnNames, String[] columnValues, String whereClause) throws SQLException
  {
    if(columnNames.length != columnValues.length)
    {
      // throw exception
    }
    String query = "UPDATE " + tableName + " SET ";
    for(int i=0; i < columnNames.length; i++)
    {
      if(i > 0)
      {
        query = query + ", ";
      }
      query = query + columnNames[i] + " = " + columnValues[i];
    }
    if(whereClause != null && !whereClause.trim().equals(""))
    {
      query = query + " WHERE " + whereClause;
    }

    Statement s = connection.createStatement();
    s.executeUpdate(query);
    s.close();
  }

  private String getColumnNameString(String[] columnNames)
  {
    String columnNameString = "";

    for(int i=0; i < columnNames.length; i++)
    {
      if(i > 0)
      {
        columnNameString = columnNameString + ", ";
      }
      columnNameString = columnNameString + columnNames[i];
    }

    return columnNameString;
  }

  protected String getDBString(String str)
  {
    String dbString = "";
    int beginIndex = 0;
    int endIndex = str.indexOf("'");
    while(endIndex > -1)
    {
      dbString = dbString + str.substring(beginIndex, endIndex);
      dbString = dbString + "''";
      // Move to the character after the added "'";
      beginIndex = endIndex + 1;
      endIndex = str.indexOf("'", beginIndex);
    }
    dbString = "'" + dbString + str.substring(beginIndex) + "'";

    return dbString;
  }

  protected String getDBDate(java.util.Date date)
  {
    String dbString = "#" + DateFormat.getDateInstance(DateFormat.SHORT).format(date) + "#";
//    String dbString = "" + DateFormat.getDateInstance(DateFormat.SHORT).format(date) + "";

    return dbString;
  }

  private IDString getIDString(CustResultSet rs, String idColumnName,
    String textColumnName) throws SQLException
  {
    IDString data = null;
    int id = rs.getInt(idColumnName);
    String text = rs.getString(textColumnName);

    if(text != null)
    {
      data = new IDString(id, text);
    }

    return data;
  }

  protected IDString getIDString(ResultSet rs, String idColumnName,
    String textColumnName) throws SQLException
  {
    IDString data = null;
    int id = rs.getInt(idColumnName);
    String text = rs.getString(textColumnName);

    if(text != null)
    {
      data = new IDString(id, text);
    }

    return data;
  }

  public void commit() throws SQLException
  {
    connection.commit();
  }

  public void rollback() throws SQLException
  {
    connection.rollback();
  }

  protected String getTableName()
  {
    return tableName;
  }

  protected void setTableName(String tableName)
  {
    this.tableName = tableName;
  }
}

