/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

/* Note:
 * This is based on a technique used eons ago. Developed by Jon Kern
 * and his co-workers at Lightship, in particular Ed Carr.
 */

package server;

import java.sql.*;

/**
 * A work in process.
 * This class is responsible for managing connecting to the database,
 * and providing other utility-like functionality.
 * @note The driver should be externalized into config file one day...*/
public class DMServer
{
  private KeyTable keyTable = null;

  /**
   * @label sys 
   */
  Connection systemConnection = null;

  /**
   * @label user 
   */
  Connection userConnection = null;

  /**
   * Constructor to set up the database.
   * Change the driver name and database name here.
   * @note Need to load driver and DB name from property file.
   */
  public DMServer() throws SQLException, ClassNotFoundException
  {
    System.out.println("setting up Server");

    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
    systemConnection = DriverManager.getConnection("jdbc:odbc:CashSales", "SYSDBA", "masterkey");
    systemConnection.setAutoCommit(false);
    keyTable = new KeyTable(systemConnection);
    userConnection = DriverManager.getConnection("jdbc:odbc:CashSales", "SYSDBA", "masterkey");
    userConnection.setAutoCommit(false);
  }

  public Connection getUserConnection()
  {
    return userConnection;
  }

  public int getNextKey(String columnName, String tableName) throws SQLException
  {
    return keyTable.getNextKey(columnName, tableName);
  }
}  // ENDCLASS DMServer

