/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

/* Note:
 * This is based on a technique used eons ago. Developed by Jon Kern
 * and his co-workers at Lightship, primarily Ed Carr.
 */

package server;

import java.sql.*;

/**
 * This is simply the start on a useful Helper-style class...*/
public class CustResultSet
{
  ResultSet resultSet = null;
  
  public CustResultSet(ResultSet rs)
  {
    resultSet = rs;
  }

  public int getInt(String columnName) throws SQLException
  {
    return resultSet.getInt(columnName);
  }

  public double getDouble(String columnName) throws SQLException
  {
    return resultSet.getDouble(columnName);
  }

  public String getString(String columnName) throws SQLException
  {
    String string = resultSet.getString(columnName);
    if(string == null)
    {
      string = "";
    }

    return string;
  }

  public boolean getBoolean(String columnName) throws SQLException
  {
    return resultSet.getBoolean(columnName);
  }

  public Date getDate(String columnName) throws SQLException
  {
    return resultSet.getDate(columnName);
  }

  public boolean next() throws SQLException
  {
    return resultSet.next();
  }
}

