/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package problem_domain;

import java.util.Vector;
import java.sql.SQLException;
import server.CustResultSet;

/**
 * This interface can help to decouple the packages and classes from explicit
 * knowledge of a Specific DM class.*/
public interface IDM
{
    void insert(Object obj) throws SQLException;

    void update(Object obj) throws SQLException;

    /**
     * This represents the "shallow retrieve." That is, the ability to return
     * just the ID and Name of an object. Useful for browsing, or for pick
     * lists. (A technique to avoid a deep retrieve of all objects,
     * fully-formed, which could be quite expensive in terms of performance
     * and using potentially scarce DBMS resources.)
     */
    Vector getList() throws SQLException;

    void save(Object obj) throws SQLException;

    Object getData(CustResultSet rs) throws SQLException;

    /**
     * Return all objects.
     */
    Vector getAll() throws SQLException;
}
