/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package problem_domain;

import java.math.BigDecimal;


/**
 * The detail class holds the association-level information. That is, a Sale is more than a list of products sold. This class can serve to store quantity of a specific product.
 * @stereotype mi-detail 
 * @persistent*/
public class CashSaleDetail {

    /** This indicates how many of this item are being purchased. 
     * @rdbLogicalType INTEGER*/
    private int qty;

    /**
     * This would allow you to use units like: each, pounds, case. Of course, you would have to have the intelligence on the
     * product pricing side as well. We won't be using this <g>.
     * @rdbLogicalType INTEGER
     */
    final private int UOM = 0;
    //    private BigDecimal negotiatedPrice;

    /**
     * This is the item being scanned in/sold. This object holds all the pertinent details.
     * @clientCardinality 0..*
     * @supplierCardinality 1*/
    private ProductDesc product;

    /**
     * @shapeType Hyperlink 
     */
    /*# private SaleDetail attribute1; */

/* ========================================
 * Constructors
 * ======================================== */

    public CashSaleDetail(ProductDesc prod) {
        product = prod;
        qty = 1;
    }

/* ========================================
 * Business Methods
 * ======================================== */

    public BigDecimal calcTotal() {
        return product.calcPriceForQty(qty);
    }

    public boolean verifyAvailability() {
        return false;
    }

    public void deductQty() {
    }

/* ========================================
 * Accessor/Mutator Methods
 * ======================================== */

    public int getQty() {
        return qty;
    }

    public void setQty(int aQty) {
        qty = aQty;
    }

    public ProductDesc getProductDesc() {
        // Should probably return a clone to be safer.
        return product;
    }
} // ENDCLASS CashSaleDetail

