/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package data_management;

import java.util.*;
import java.sql.*;
import java.math.*;
import java.text.*;

import problem_domain.*;
import server.*;

/**
 * @robustness Entity
 * @subtitle (The database)
 * @url element://model:project::PurchaseTransaction/jdt:e_class:src:server.Database
 */
public class SaleDM extends Database implements IDM
{
	/**
     * Constructor must be passed the Server instance.
     */
    public SaleDM(DMServer dmServer)
    {
        super(dmServer.getUserConnection(), "CashSaleHistory");
        this.dmServer = dmServer;
        // Useful to roll your own custom format. You must use it for parsing
        // when reading back from database.
        dateFormat = new SimpleDateFormat ("yyyy-MM-dd");

		// set number format
		this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setMaximumFractionDigits(2);
    }

    /** I'd prefer it if this was protected... */
    public void insert(Object obj) throws SQLException
    {
        CashSale data = (CashSale)obj;
        // get a new key (ID)
        data.setId(dmServer.getNextKey("ID", getTableName()));

		String subTotalValue = data.getSubtotal().toString();
        String taxValue = data.getTax().toString();

        //  Build up list of values based on object state
        String[] columnValues = new String[]
        {
            new Integer(data.getId()).toString(),
                getDBString( dateFormat.format( data.getTime() ) ),
// JK This can be used in conjunction with the type of date format
//    supported by DBMS (e.g., #26.02.01#). However, it doesn't seem to
//    be as portable as one might hope. Therefore, a simple string is
//    used instead.
// JK                getDBDate(data.getTime()),
			removeIllegalChars(numberFormat.format(new BigDecimal(subTotalValue))),
			removeIllegalChars(numberFormat.format(new BigDecimal(taxValue)))
        };

        // Insert the new row
        super.insert(insertableColumns, columnValues);
    }

    /** I'd prefer it if this was protected, but it is part of the interface... */
    public void update(Object obj) throws SQLException
    {
        CashSale data = (CashSale)obj;
		String subTotalValue = data.getSubtotal().toString();
        String taxValue = data.getTax().toString();

        String[] columnValues = new String[]
        {
            getDBString( dateFormat.format( data.getTime() ) ),
// JK            getDBDate(data.getTime()),
			removeIllegalChars(numberFormat.format(new BigDecimal(subTotalValue))),
			removeIllegalChars(numberFormat.format(new BigDecimal(taxValue)))
        };

        super.update(updatableColumns, columnValues, "ID = " + data.getId());
    }

    /**
     * This represents the "shallow retrieve." That is, the ability to return
     * just the ID and Name of an object. Useful for browsing, or for pick
     * lists. (A technique to avoid a deep retrieve of all objects,
     * fully-formed, which could be quite expensive in terms of performance
     * and using potentially scarce DBMS resources.)
     */
    public Vector getList() throws SQLException
    {
        return super.getIDStringList();
    }

    /**
     * This retrieves all of the cash sales in the database :=)
     * @note someday, we'll add some date "range" clauses.
     */
    public Vector getAll() throws SQLException
    {
        return super.selectList(SaleDM.columnNames, "", "SaleTime");
    }

    public void save(Object obj) throws SQLException
    {
        CashSale data = (CashSale)obj;
        String id = "";

        // This implies a new object
        if (data.getId() == 0)
        {
            insert(data);
        }
        else
        {
            update(data);
        }
        commit();
    }

    public Object getData(CustResultSet rs) throws SQLException
    {
        CashSale data = new CashSale();

        // Parse the previous string back into a Date.
        //	ParsePosition pos = new ParsePosition(0);

        data.setId(rs.getInt("ID"));
        //    data.setTime( dateFormat.parse( rs.getString("SaleTime"), pos ) );
        data.setTime(rs.getDate("SaleTime"));
        data.setSubtotal(new BigDecimal(rs.getDouble("Subtotal")));
        data.setTax(new BigDecimal(rs.getDouble("Tax")));

        return data;
    }

    private final static String[] columnNames = new String[]
    {
        "ID",
        "SaleTime",
        "Subtotal",
        "Tax"
    };

    final static String[] insertableColumns = new String[]
    {
        "ID",
        "SaleTime",
        "Subtotal",
        "Tax"
    };

    final static String[] updatableColumns = new String[]
    {
        "SaleTime",
        "Subtotal",
        "Tax"
    };

    /** Helper function to strip chars from currency input widget. */
    private String removeIllegalChars(String string)
    {
        StringBuffer sb = new StringBuffer(string);
        for (int i = 0; i < sb.length(); i++)
            if (sb.charAt(i) == ',')
                sb.setCharAt(i, '.');
        return sb.toString();
    } // END removeIllegalChars()

    DMServer dmServer = null;
    SimpleDateFormat dateFormat = null;
    NumberFormat currencyFormat = NumberFormat.getCurrencyInstance();
    NumberFormat numberFormat;
}
