/**
 * THIS FILE IS GENERATED BY SAP BI MMR: JMI GENERATOR VERSION 1.1.1
 * GENERATED AT Tuesday, February 15, 2005 12:15:31 AM CET
 **/
package org.omg.cwm.analysis.datamining;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.HashMap;

import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefFeatured;


import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.IMMRAssociation;


/**
 * Data mining is the application of mathematical or statistical processes 
 * for the purpose of extracting hidden knowledge from large data sets. This 
 * knowledge is subsequently used as actionable business intelligence.
 * 
 * 
 * 
 * Data 
 * mining techniques provide descriptive information that is manifest in inherent 
 * patterns or relations between the data. This can be achieved, for example, 
 * with algorithms for clustering or association rules detection (link analysis).
 * 
 * 
 * 
 * They 
 * also uncover correlations, often due to causal relationships, between the 
 * data and a specific target property. This information is used to make predictions 
 * about unknown data or future behavior. Techniques generating these models 
 * are known as supervised learning algorithms, and include classification 
 * and numeric prediction algorithms.
 * 
 * 
 * 
 * Whereas most analysis tools support 
 * the retrospective analysis of data sets by verifying a user?s hypotheses, 
 * data mining attempts to discover trends and behaviors without the need 
 * for guessing about possible relationships.
 * 
 * 
 * 
 * Data mining tools are particularly 
 * effective in the data warehouse environment, because data warehouses offer 
 * large quantities of cleansed business data for consumption by data mining 
 * tools. Also, the advanced query and analytical capabilities available in 
 * most data warehouses (e&#46;g&#46;, relational databases, OLAP servers, 
 * and information visualization tools) can be used to great advantage by 
 * data mining tools in their formulation of models, and in the evaluation 
 * of those models by human users.
 * 
 * 
 * 
 * The Data Mining package depends on the 
 * following packages:
 * 
 * 
 * 
 *     org.omg::CWM::ObjectModel::Core
 * 
 *     org.omg::CWM::ObjectModel::Instance
 * 
 * 
 * 
 * The 
 * CWM Data Mining metamodel represents three conceptual areas: The overall 
 * Model description itself, Settings, and Attributes. Each area is represented 
 * by the diagrams in Figs. 15-1, 15-2, and 15-3, respectively.
 * 
 * 
 * 
 * The Model 
 * conceptual area consists of a generic representation of a data mining model 
 * (that is, a mathematical model produced or generated by the execution of 
 * a data mining algorithm). This consists of MiningModel, a representation 
 * of the mining model itself, MiningSettings, which drive the construction 
 * of the model, ApplicationInputSpecification, which specifies the set of 
 * input attributes for the model, and MiningModelResult, which represents 
 * the result set produced by the testing or application of a generated model.
 * 
 * 
 * 
 * The 
 * Settings conceptual area elaborates further on the Mining Settings and 
 * their usage relationships to the attributes of the input specification.
 * 
 * 
 * 
 * Mining 
 * Settings has four subclasses representing settings for StatisticsSettings, 
 * ClusteringSettings, SupervisedMiningSettings and AssociationRulesSettings. 
 * The SupervisedMiningSettings are further subclassed as ClassificationSettings 
 * and RegressionSettings, and a CostMatrix is defined for representing cost 
 * values associated with misclassifications.
 * 
 * 
 * 
 * AttributeUsageRelation consists 
 * of attributes that further classify the usage of MiningAttributes by MiningSettings 
 * (e&#46;g&#46;, relative weight).  Several association are also used to 
 * explicitly define requirements placed on attributes by certain subclasses 
 * of settings (e&#46;g&#46;, target, transactionId and itemId).
 * 
 * 
 * 
 * The Attributes 
 * conceptual area defines two subclasses of Mining Attribute:
 * 
 * 
 * 
 * NumericAttribute 
 * and CategoricalAttribute. Category represents the category properties and 
 * values that either a CategoricalAttribute or OrdinalAttribute might possess, 
 * while CategoryHierarchy represents any taxonomy that a CategoricalAttribute 
 * might be associated with.
 * 
 * 
 * 
 * The inheritance of the Data Mining metamodel 
 * from the CWM ObjectModel is shown in Fig. 15-4.
 * 
 * 
 * 
 * OCL Representation of 
 * Data Mining Constraints
 * 
 * 
 * 
 * [C-1] Function must specify "AssociationRules.
 * 
 * context 
 * AssociationRulesSettings inv:
 * 
 * self.function = "AssociationRules
 * 
 * 
 * 
 * [C-2] 
 * Category values must be unique.
 * 
 * context CategoricalAttribute inv:
 * 
 * self.category->forAll( 
 * c1, c2 | c1.value = c2.value implies c1 = c2 )
 * 
 * 
 * 
 * [C-3] An instance of 
 * Category must be owned by precisely one instance of
 * 
 * CategoricalAttribute 
 * or any of its subclasses.
 * 
 * context Category inv:
 * 
 * self.categoricalAttribute->isEmpty 
 * xor self.ordinalAttribute->isEmpty
 * 
 * 
 * 
 * [C-4] Function must specify "Classification".
 * 
 * context 
 * ClassificationSettings inv:
 * 
 * self.function = "Classification"
 * 
 * 
 * 
 * [C-5] 
 * Function must specify "Clustering".
 * 
 * context ClusteringSettings inv:
 * 
 * self.function 
 * = "Clustering"
 * 
 * 
 * 
 * [C-6] maxNumberOfClusters must be positive.
 * 
 * context 
 * ClusteringSettings inv:
 * 
 * self.maxNumberOfClusters > 0
 * 
 * 
 * 
 * [C-7] Attributes 
 * must have unique names.
 * 
 * context MiningDataSpecification inv:
 * 
 * self.attribute->forAll( 
 * a1, a2 | a1.name = a2.name implies a1 = a2 )
 * 
 * 
 * 
 * [C-8] Function and algorithm 
 * must be equal to function and algorithm of
 * 
 * MiningSettings, respectively.
 * 
 * context 
 * MiningModel inv:
 * 
 * self.settings->isEmpty or (self.function = self.settings.function 
 * and
 * 
 * self.algorithm = self.settings.algorithm)
 * 
 * 
 * 
 * [C-9] lowerBound must 
 * be less than or equal to upperBound.
 * 
 * context NumericAttribute inv:
 * 
 * self.lowerBound 
 * <= self.upperBound
 * 
 * 
 * 
 * [C-10] Function must specify "Regression".
 * 
 * context 
 * RegressionSettings inv:
 * 
 * self.function = "Regression"
 * 
 * 
 * 
 * [C-11] Function 
 * must specify "StatisticalAnalysis".
 * 
 * context StatisticsSettings inv:
 * 
 * self.function 
 * = "StatisticalAnalysis"
 */
public class DataMiningPackageImpl implements com.sap.ip.mmr.m1layer.IMMRObject, org.omg.cwm.analysis.datamining.DataMiningPackage {

// Java serialized version UID
static final long serialVersionUID = -917908L;



	protected static final com.sap.tc.logging.Location ___location = com.sap.ip.mmr.foundation.Utilities.getUtilities().getLocation(javax.jmi.reflect.RefBaseObject.class);

// variables
protected java.lang.String ___mofId;
	
transient protected com.sap.ip.mmr.StateEnum ___state = com.sap.ip.mmr.StateEnum.STATE_NEW;
final protected java.lang.String ___generatorVersion = "1.1.1";
transient protected com.sap.ip.mmr.IRepository ___repository;
transient protected javax.jmi.reflect.RefObject ___metaObject;
transient protected javax.jmi.reflect.RefFeatured ___composite = null;

transient protected com.sap.ip.mmr.m1layer.IMMRObject ___instantiator;

protected java.lang.String ___createdAt;
protected java.lang.String ___createdBy;
protected java.lang.String ___lastChangedAt;
protected java.lang.String ___lastChangedBy;
protected java.lang.String ___release;
protected int ___deprecated;


protected java.lang.String ___qualifiedName;
protected java.lang.String ___qualifiedNameImmediatePackage;
transient protected javax.jmi.reflect.RefPackage ___immediatePackage = null;


// constructors
public DataMiningPackageImpl() {
}
public DataMiningPackageImpl(IRepository repository) {
  ___repository = repository;
  ___mofId = com.sap.ip.mmr.Repository.createMofId();
}



// each imported package where:
//   isClustered and
//   Import.visibility == public_vis and
//   importedNamespace.visibility == public_vis
public org.omg.cwm.objectmodel.core.CorePackage getCore() { return (org.omg.cwm.objectmodel.core.CorePackage) refPackage("Core"); } 
public org.omg.cwm.objectmodel.instance.InstancePackage getInstance() { return (org.omg.cwm.objectmodel.instance.InstancePackage) refPackage("Instance"); } 

// each contained package where visibility = public_vis

// each directly contained class with visibility = public_vis
public org.omg.cwm.analysis.datamining.ApplicationInputSpecificationClass getApplicationInputSpecification() { return (org.omg.cwm.analysis.datamining.ApplicationInputSpecificationClass) refClass("ApplicationInputSpecification"); } 
public org.omg.cwm.analysis.datamining.AttributeUsageRelationClass getAttributeUsageRelation() { return (org.omg.cwm.analysis.datamining.AttributeUsageRelationClass) refClass("AttributeUsageRelation"); } 
public org.omg.cwm.analysis.datamining.CategoryClass getCategory() { return (org.omg.cwm.analysis.datamining.CategoryClass) refClass("Category"); } 
public org.omg.cwm.analysis.datamining.CategoryHierarchyClass getCategoryHierarchy() { return (org.omg.cwm.analysis.datamining.CategoryHierarchyClass) refClass("CategoryHierarchy"); } 
public org.omg.cwm.analysis.datamining.CostMatrixClass getCostMatrix() { return (org.omg.cwm.analysis.datamining.CostMatrixClass) refClass("CostMatrix"); } 
public org.omg.cwm.analysis.datamining.MiningAttributeClass getMiningAttribute() { return (org.omg.cwm.analysis.datamining.MiningAttributeClass) refClass("MiningAttribute"); } 
public org.omg.cwm.analysis.datamining.MiningDataSpecificationClass getMiningDataSpecification() { return (org.omg.cwm.analysis.datamining.MiningDataSpecificationClass) refClass("MiningDataSpecification"); } 
public org.omg.cwm.analysis.datamining.MiningModelClass getMiningModel() { return (org.omg.cwm.analysis.datamining.MiningModelClass) refClass("MiningModel"); } 
public org.omg.cwm.analysis.datamining.MiningModelResultClass getMiningModelResult() { return (org.omg.cwm.analysis.datamining.MiningModelResultClass) refClass("MiningModelResult"); } 
public org.omg.cwm.analysis.datamining.NumericAttributeClass getNumericAttribute() { return (org.omg.cwm.analysis.datamining.NumericAttributeClass) refClass("NumericAttribute"); } 
public org.omg.cwm.analysis.datamining.SupervisedMiningModelClass getSupervisedMiningModel() { return (org.omg.cwm.analysis.datamining.SupervisedMiningModelClass) refClass("SupervisedMiningModel"); } 
public org.omg.cwm.analysis.datamining.CategoricalAttributeClass getCategoricalAttribute() { return (org.omg.cwm.analysis.datamining.CategoricalAttributeClass) refClass("CategoricalAttribute"); } 
public org.omg.cwm.analysis.datamining.OrdinalAttributeClass getOrdinalAttribute() { return (org.omg.cwm.analysis.datamining.OrdinalAttributeClass) refClass("OrdinalAttribute"); } 
public org.omg.cwm.analysis.datamining.MiningSettingsClass getMiningSettings() { return (org.omg.cwm.analysis.datamining.MiningSettingsClass) refClass("MiningSettings"); } 
public org.omg.cwm.analysis.datamining.ClusteringSettingsClass getClusteringSettings() { return (org.omg.cwm.analysis.datamining.ClusteringSettingsClass) refClass("ClusteringSettings"); } 
public org.omg.cwm.analysis.datamining.StatisticsSettingsClass getStatisticsSettings() { return (org.omg.cwm.analysis.datamining.StatisticsSettingsClass) refClass("StatisticsSettings"); } 
public org.omg.cwm.analysis.datamining.SupervisedMiningSettingsClass getSupervisedMiningSettings() { return (org.omg.cwm.analysis.datamining.SupervisedMiningSettingsClass) refClass("SupervisedMiningSettings"); } 
public org.omg.cwm.analysis.datamining.ClassificationSettingsClass getClassificationSettings() { return (org.omg.cwm.analysis.datamining.ClassificationSettingsClass) refClass("ClassificationSettings"); } 
public org.omg.cwm.analysis.datamining.RegressionSettingsClass getRegressionSettings() { return (org.omg.cwm.analysis.datamining.RegressionSettingsClass) refClass("RegressionSettings"); } 
public org.omg.cwm.analysis.datamining.AssociationRulesSettingsClass getAssociationRulesSettings() { return (org.omg.cwm.analysis.datamining.AssociationRulesSettingsClass) refClass("AssociationRulesSettings"); } 
public org.omg.cwm.analysis.datamining.ApplicationAttributeClass getApplicationAttribute() { return (org.omg.cwm.analysis.datamining.ApplicationAttributeClass) refClass("ApplicationAttribute"); } 

// each directly contained association with visibility = public_vis
public org.omg.cwm.analysis.datamining.DerivedFromSettings getDerivedFromSettings() { return (org.omg.cwm.analysis.datamining.DerivedFromSettings) refAssociation("DerivedFromSettings"); } 
public org.omg.cwm.analysis.datamining.InputSpecOwnsAttributes getInputSpecOwnsAttributes() { return (org.omg.cwm.analysis.datamining.InputSpecOwnsAttributes) refAssociation("InputSpecOwnsAttributes"); } 
public org.omg.cwm.analysis.datamining.ProducedByModel getProducedByModel() { return (org.omg.cwm.analysis.datamining.ProducedByModel) refAssociation("ProducedByModel"); } 
public org.omg.cwm.analysis.datamining.HasAttribute getHasAttribute() { return (org.omg.cwm.analysis.datamining.HasAttribute) refAssociation("HasAttribute"); } 
public org.omg.cwm.analysis.datamining.UsesAsTaxonomy getUsesAsTaxonomy() { return (org.omg.cwm.analysis.datamining.UsesAsTaxonomy) refAssociation("UsesAsTaxonomy"); } 
public org.omg.cwm.analysis.datamining.ContainsCategory getContainsCategory() { return (org.omg.cwm.analysis.datamining.ContainsCategory) refAssociation("ContainsCategory"); } 
public org.omg.cwm.analysis.datamining.ContainsAttributeUsage getContainsAttributeUsage() { return (org.omg.cwm.analysis.datamining.ContainsAttributeUsage) refAssociation("ContainsAttributeUsage"); } 
public org.omg.cwm.analysis.datamining.UsesAsInput getUsesAsInput() { return (org.omg.cwm.analysis.datamining.UsesAsInput) refAssociation("UsesAsInput"); } 
public org.omg.cwm.analysis.datamining.PertainsToAttribute getPertainsToAttribute() { return (org.omg.cwm.analysis.datamining.PertainsToAttribute) refAssociation("PertainsToAttribute"); } 
public org.omg.cwm.analysis.datamining.UsesItemId getUsesItemId() { return (org.omg.cwm.analysis.datamining.UsesItemId) refAssociation("UsesItemId"); } 
public org.omg.cwm.analysis.datamining.UsesTransactionId getUsesTransactionId() { return (org.omg.cwm.analysis.datamining.UsesTransactionId) refAssociation("UsesTransactionId"); } 
public org.omg.cwm.analysis.datamining.UsesAsTarget getUsesAsTarget() { return (org.omg.cwm.analysis.datamining.UsesAsTarget) refAssociation("UsesAsTarget"); } 
public org.omg.cwm.analysis.datamining.UsesCostMatrix getUsesCostMatrix() { return (org.omg.cwm.analysis.datamining.UsesCostMatrix) refAssociation("UsesCostMatrix"); } 
public org.omg.cwm.analysis.datamining.MiningModelOwnsInputSpecification getMiningModelOwnsInputSpecification() { return (org.omg.cwm.analysis.datamining.MiningModelOwnsInputSpecification) refAssociation("MiningModelOwnsInputSpecification"); } 
public org.omg.cwm.analysis.datamining.SupervisedMiningModelReferencesTargetAttribute getSupervisedMiningModelReferencesTargetAttribute() { return (org.omg.cwm.analysis.datamining.SupervisedMiningModelReferencesTargetAttribute) refAssociation("SupervisedMiningModelReferencesTargetAttribute"); } 
public org.omg.cwm.analysis.datamining.OrdersCategory getOrdersCategory() { return (org.omg.cwm.analysis.datamining.OrdersCategory) refAssociation("OrdersCategory"); } 

// each directly contained StructType with visibility = public_vis

// each directly contained EnumType with visibility = public_vis
public org.omg.cwm.analysis.datamining.AttributeType createAttributeType(java.lang.String value) { return (org.omg.cwm.analysis.datamining.AttributeType) refGetEnum("org.omg.cwm.analysis.datamining.AttributeType",value); } 
public org.omg.cwm.analysis.datamining.AttributeUsage createAttributeUsage(java.lang.String value) { return (org.omg.cwm.analysis.datamining.AttributeUsage) refGetEnum("org.omg.cwm.analysis.datamining.AttributeUsage",value); } 
public org.omg.cwm.analysis.datamining.CategoryProperty createCategoryProperty(java.lang.String value) { return (org.omg.cwm.analysis.datamining.CategoryProperty) refGetEnum("org.omg.cwm.analysis.datamining.CategoryProperty",value); } 
public org.omg.cwm.analysis.datamining.OrderType createOrderType(java.lang.String value) { return (org.omg.cwm.analysis.datamining.OrderType) refGetEnum("org.omg.cwm.analysis.datamining.OrderType",value); } 

// return main object properties as String
public String toString() {
  	return ___qualifiedName + "::" + ___mofId + " (" + super.toString() + ") ";

}

// Meta object
public javax.jmi.reflect.RefObject refMetaObject() {
    return ___repository.selectM2ByName("org.omg.cwm.analysis.DataMining", false);

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refImmediatePackage()
 */
public javax.jmi.reflect.RefPackage refImmediatePackage() {
  		if (___immediatePackage != null) {
  			if (com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT.equals(((IMMRObject) ___immediatePackage).get___QualifiedName())) {
  				return null;
  			}
  	    } else {
  		  if (___qualifiedNameImmediatePackage != null && ___qualifiedNameImmediatePackage.compareTo(com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT) != 0) {
  		 	// set the package
  			___immediatePackage = ___repository.getTopLevelPackageM1().refPackage(___qualifiedNameImmediatePackage);
  		  }
  	    }
  	    return ___immediatePackage;

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refOutermostPackage()
 */
public javax.jmi.reflect.RefPackage refOutermostPackage() {
  		javax.jmi.reflect.RefPackage rp = refImmediatePackage();
  		if (rp == null) {
  			return (javax.jmi.reflect.RefPackage) this;
  		} else {
  			if (com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT.equals(((IMMRObject) rp).get___QualifiedName())) {
  				return (javax.jmi.reflect.RefPackage) this;
  			}
  		}
  		if (rp != null && !(rp.equals(this))) {
  			javax.jmi.reflect.RefPackage rp_ = rp.refOutermostPackage();
  			if (rp_ != null) {
  				rp = rp_;
  			}
  		}
  		return rp;

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refMofId()
 */
public String refMofId() {
  	return ___mofId;

}

/**
 * @see javax.jmi.reflect.RefBaseObject#refVerifyConstraints(boolean)
 */
public Collection refVerifyConstraints(boolean deepVerify) {
  		com.sap.ip.mmr.m1layer.Verifyer v = com.sap.ip.mmr.m1layer.Verifyer.createVerifyer();
  		return v.refVerifyConstraints(this,deepVerify);

}

/**
 * @see com.sap.ip.mmr.m1layer.IMMRObject#get___Repository()
 */
public IRepository get___Repository() {
  	return ___repository;

}

/**
 * @see com.sap.ip.mmr.m1layer.IMMRObject#set___Repository(IRepository)
 */
public void set___Repository(IRepository repository) {
  	___repository = repository;

}

// equality of two (IMMRObject) objects 
public boolean equals(java.lang.Object other) {
      java.lang.String otherMofId = null;
  	if (other instanceof javax.jmi.reflect.RefBaseObject) {
          otherMofId = ((javax.jmi.reflect.RefBaseObject)other).refMofId();
  	} else if (other instanceof java.lang.String) {
          otherMofId = (java.lang.String)other;
      }
      return ___mofId.equals(otherMofId);

}

// computes the hasCode of this object
public int hashCode() {
  	return ___mofId.hashCode();

}

// Was this object changed?
public boolean is___Changed() {
  	return ___state == com.sap.ip.mmr.StateEnum.STATE_CHANGED;

}

// Is the instance new or from persistence layer?
public boolean is___New() {
  	return ___state == com.sap.ip.mmr.StateEnum.STATE_NEW;

}

/*
 * @see com.sap.ip.mmr.m1layer.IMMRObject#get___State()
*/
public com.sap.ip.mmr.StateEnum get___State() {
  	return ___state;

}

/*
 * @see com.sap.ip.mmr.m1layer.IMMRObject#set___State()
*/
public void set___State(com.sap.ip.mmr.StateEnum state) {
  	___state = com.sap.ip.mmr.StateEnum.changeState(___state,state);

}

public java.lang.String get___GeneratorVersion() {
  	return ___generatorVersion;

}

public void set___CreatedAt(String createdAt) {
  	this.___createdAt = createdAt;

}

public java.lang.String get___CreatedAt() {
  	return ___createdAt;

}

public void set___CreatedBy(String createdBy) {
  	this.___createdBy = createdBy;

}

public java.lang.String get___CreatedBy() {
  	return ___createdBy;

}

public void set___LastChangedAt(String lastChangedAt) {
  	this.___lastChangedAt = lastChangedAt;

}

public java.lang.String get___LastChangedAt() {
  	return ___lastChangedAt;

}

public void set___LastChangedBy(String lastChangedBy) {
  	this.___lastChangedBy = lastChangedBy;

}

public java.lang.String get___LastChangedBy() {
  	return ___lastChangedBy;

}

public void set___Release(String release) {
  	this.___release = release;

}

public java.lang.String get___Release() {
  	return ___release;

}

public void set___Deprecated(int deprecated) {
  	this.___deprecated = deprecated;

}

public int get___Deprecated() {
  	return ___deprecated;

}

public void set___ImmediateComposite(javax.jmi.reflect.RefFeatured feature) {
  	___composite = feature;

}

// copy the attributes of another instance to this instance
public void ___copy(com.sap.ip.mmr.m1layer.IMMRObject o) {
  this.___mofId = o.get___MofId();
  this.___repository = o.get___Repository();
  this.___qualifiedName = o.get___QualifiedName();
  this.___qualifiedNameImmediatePackage = o.get___QualifiedNameImmediatePackage();
  this.___immediatePackage = o.get___ImmediatePackage();
  this.___composite = null;
  this.___createdAt = o.get___CreatedAt();
  this.___createdBy = o.get___CreatedBy();
  this.___lastChangedAt = o.get___LastChangedAt();
  this.___lastChangedBy = o.get___LastChangedBy();
  this.___release = o.get___Release();
  this.___deprecated = o.get___Deprecated();

}

// returns the MOF Id
public String get___MofId() {
  return ___mofId;

}

// set the MOF Id !!! TO BE USED BY MMR ONLY !!!
public void set___MofId(String mofId) {
  this.___mofId = mofId;

}

// returns the qualified name of this class
public java.lang.String get___QualifiedName() {
  return ___qualifiedName;

}

// returns the qualified name of the immediate package of this class
public java.lang.String get___QualifiedNameImmediatePackage() {
  return ___qualifiedNameImmediatePackage;

}

// returns the immediate package
public javax.jmi.reflect.RefPackage get___ImmediatePackage() {
  return ___immediatePackage;

}

// set the qualified name of this class
public void set___QualifiedName(String qualifiedName) {
  ___qualifiedName = qualifiedName;

}

// set the qualified name of the immediate package this class
public void set___QualifiedNameImmediatePackage(String qualifiedNameImmediatePackage) {
  ___qualifiedNameImmediatePackage = qualifiedNameImmediatePackage;

}

// set the immediate package
public void set___ImmediatePackage(javax.jmi.reflect.RefPackage immediatePackage) {
  		if (immediatePackage != null
  			&& ((com.sap.ip.mmr.m1layer.IMMRObject) immediatePackage).get___QualifiedName().equals(
  				com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT)) {
  			___immediatePackage = null;
  		} else {
  			___immediatePackage = immediatePackage;
  		}

}

// see com.sap.ip.mmr.m1layer.IMMRObject
public List get___ListOfInstantiators() {
  		ArrayList list = new ArrayList(1);
  		IMMRObject parent = get___Instantiator();
  		while (parent != null) {
  			if (list.size() == 0) {
  				list.add(parent);
  			} else {
  				list.add(0, parent);
  			}
  			parent = parent.get___Instantiator();
  		}
  		return list;

}

// see com.sap.ip.mmr.m1layer.IMMRObject
public IMMRObject get___Instantiator() {
  return ___instantiator;

}

// see com.sap.ip.mmr.m1layer.IMMRObject
public void set___Instantiator(IMMRObject instantiator) {
  ___instantiator = instantiator;

}

/**
* @see com.sap.ip.mmr.m1layer.IMMRObject#throwsConstraintViolations()
*/
public boolean throwsConstraintViolations() {
  return true;

}

/**
 * @see javax.jmi.reflect.RefPackage#refGetEnum(String, String)
 */
public RefEnum refGetEnum(String enumName, String name) {
     RefEnum re = null;
     if (enumName.compareTo("AttributeType") == 0) {
        if (name.compareTo("numerical") == 0) {
           re = org.omg.cwm.analysis.datamining.AttributeTypeEnum.NUMERICAL;
        }
        else if (name.compareTo("categorical") == 0) {
           re = org.omg.cwm.analysis.datamining.AttributeTypeEnum.CATEGORICAL;
        }
     }
     else if (enumName.compareTo("AttributeUsage") == 0) {
        if (name.compareTo("active") == 0) {
           re = org.omg.cwm.analysis.datamining.AttributeUsageEnum.ACTIVE;
        }
        else if (name.compareTo("inactive") == 0) {
           re = org.omg.cwm.analysis.datamining.AttributeUsageEnum.INACTIVE;
        }
        else if (name.compareTo("supplementary") == 0) {
           re = org.omg.cwm.analysis.datamining.AttributeUsageEnum.SUPPLEMENTARY;
        }
     }
     else if (enumName.compareTo("CategoryProperty") == 0) {
        if (name.compareTo("negative") == 0) {
           re = org.omg.cwm.analysis.datamining.CategoryPropertyEnum.NEGATIVE;
        }
        else if (name.compareTo("positive") == 0) {
           re = org.omg.cwm.analysis.datamining.CategoryPropertyEnum.POSITIVE;
        }
        else if (name.compareTo("valid") == 0) {
           re = org.omg.cwm.analysis.datamining.CategoryPropertyEnum.VALID;
        }
        else if (name.compareTo("missing") == 0) {
           re = org.omg.cwm.analysis.datamining.CategoryPropertyEnum.MISSING;
        }
        else if (name.compareTo("invalid") == 0) {
           re = org.omg.cwm.analysis.datamining.CategoryPropertyEnum.INVALID;
        }
     }
     else if (enumName.compareTo("OrderType") == 0) {
        if (name.compareTo("inSequence") == 0) {
           re = org.omg.cwm.analysis.datamining.OrderTypeEnum.IN_SEQUENCE;
        }
        else if (name.compareTo("numeric") == 0) {
           re = org.omg.cwm.analysis.datamining.OrderTypeEnum.NUMERIC;
        }
        else if (name.compareTo("date") == 0) {
           re = org.omg.cwm.analysis.datamining.OrderTypeEnum.DATE;
        }
        else if (name.compareTo("alphabetic") == 0) {
           re = org.omg.cwm.analysis.datamining.OrderTypeEnum.ALPHABETIC;
        }
     }
     return re;

}

/**
 * Initialize the refPackage, refClass and refAssociation information
 */
private void initialize() {
    if (___refPackages == null) {
    	___refPackages = new java.util.LinkedList();
  	___refPackages.add(new RefPackageAndName("Core","org.omg.cwm.objectmodel.Core",true,null));
  	___refPackages.add(new RefPackageAndName("Instance","org.omg.cwm.objectmodel.Instance",true,null));
    }
    if (___refClasses == null) {
    	___refClasses = new java.util.LinkedList();
  	___refClasses.add(new RefClassAndName("ApplicationInputSpecification","org.omg.cwm.analysis.DataMining.ApplicationInputSpecification",null));
  	___refClasses.add(new RefClassAndName("AttributeUsageRelation","org.omg.cwm.analysis.DataMining.AttributeUsageRelation",null));
  	___refClasses.add(new RefClassAndName("Category","org.omg.cwm.analysis.DataMining.Category",null));
  	___refClasses.add(new RefClassAndName("CategoryHierarchy","org.omg.cwm.analysis.DataMining.CategoryHierarchy",null));
  	___refClasses.add(new RefClassAndName("CostMatrix","org.omg.cwm.analysis.DataMining.CostMatrix",null));
  	___refClasses.add(new RefClassAndName("MiningAttribute","org.omg.cwm.analysis.DataMining.MiningAttribute",null));
  	___refClasses.add(new RefClassAndName("MiningDataSpecification","org.omg.cwm.analysis.DataMining.MiningDataSpecification",null));
  	___refClasses.add(new RefClassAndName("MiningModel","org.omg.cwm.analysis.DataMining.MiningModel",null));
  	___refClasses.add(new RefClassAndName("MiningModelResult","org.omg.cwm.analysis.DataMining.MiningModelResult",null));
  	___refClasses.add(new RefClassAndName("NumericAttribute","org.omg.cwm.analysis.DataMining.NumericAttribute",null));
  	___refClasses.add(new RefClassAndName("SupervisedMiningModel","org.omg.cwm.analysis.DataMining.SupervisedMiningModel",null));
  	___refClasses.add(new RefClassAndName("CategoricalAttribute","org.omg.cwm.analysis.DataMining.CategoricalAttribute",null));
  	___refClasses.add(new RefClassAndName("OrdinalAttribute","org.omg.cwm.analysis.DataMining.OrdinalAttribute",null));
  	___refClasses.add(new RefClassAndName("MiningSettings","org.omg.cwm.analysis.DataMining.MiningSettings",null));
  	___refClasses.add(new RefClassAndName("ClusteringSettings","org.omg.cwm.analysis.DataMining.ClusteringSettings",null));
  	___refClasses.add(new RefClassAndName("StatisticsSettings","org.omg.cwm.analysis.DataMining.StatisticsSettings",null));
  	___refClasses.add(new RefClassAndName("SupervisedMiningSettings","org.omg.cwm.analysis.DataMining.SupervisedMiningSettings",null));
  	___refClasses.add(new RefClassAndName("ClassificationSettings","org.omg.cwm.analysis.DataMining.ClassificationSettings",null));
  	___refClasses.add(new RefClassAndName("RegressionSettings","org.omg.cwm.analysis.DataMining.RegressionSettings",null));
  	___refClasses.add(new RefClassAndName("AssociationRulesSettings","org.omg.cwm.analysis.DataMining.AssociationRulesSettings",null));
  	___refClasses.add(new RefClassAndName("ApplicationAttribute","org.omg.cwm.analysis.DataMining.ApplicationAttribute",null));
    }
    if (___refAssociations == null) {
    	___refAssociations = new java.util.LinkedList();
  	___refAssociations.add(new RefAssociationAndName("DerivedFromSettings","org.omg.cwm.analysis.DataMining.DerivedFromSettings",null));
  	___refAssociations.add(new RefAssociationAndName("InputSpecOwnsAttributes","org.omg.cwm.analysis.DataMining.InputSpecOwnsAttributes",null));
  	___refAssociations.add(new RefAssociationAndName("ProducedByModel","org.omg.cwm.analysis.DataMining.ProducedByModel",null));
  	___refAssociations.add(new RefAssociationAndName("HasAttribute","org.omg.cwm.analysis.DataMining.HasAttribute",null));
  	___refAssociations.add(new RefAssociationAndName("UsesAsTaxonomy","org.omg.cwm.analysis.DataMining.UsesAsTaxonomy",null));
  	___refAssociations.add(new RefAssociationAndName("ContainsCategory","org.omg.cwm.analysis.DataMining.ContainsCategory",null));
  	___refAssociations.add(new RefAssociationAndName("ContainsAttributeUsage","org.omg.cwm.analysis.DataMining.ContainsAttributeUsage",null));
  	___refAssociations.add(new RefAssociationAndName("UsesAsInput","org.omg.cwm.analysis.DataMining.UsesAsInput",null));
  	___refAssociations.add(new RefAssociationAndName("PertainsToAttribute","org.omg.cwm.analysis.DataMining.PertainsToAttribute",null));
  	___refAssociations.add(new RefAssociationAndName("UsesItemId","org.omg.cwm.analysis.DataMining.UsesItemId",null));
  	___refAssociations.add(new RefAssociationAndName("UsesTransactionId","org.omg.cwm.analysis.DataMining.UsesTransactionId",null));
  	___refAssociations.add(new RefAssociationAndName("UsesAsTarget","org.omg.cwm.analysis.DataMining.UsesAsTarget",null));
  	___refAssociations.add(new RefAssociationAndName("UsesCostMatrix","org.omg.cwm.analysis.DataMining.UsesCostMatrix",null));
  	___refAssociations.add(new RefAssociationAndName("MiningModelOwnsInputSpecification","org.omg.cwm.analysis.DataMining.MiningModelOwnsInputSpecification",null));
  	___refAssociations.add(new RefAssociationAndName("SupervisedMiningModelReferencesTargetAttribute","org.omg.cwm.analysis.DataMining.SupervisedMiningModelReferencesTargetAttribute",null));
  	___refAssociations.add(new RefAssociationAndName("OrdersCategory","org.omg.cwm.analysis.DataMining.OrdersCategory",null));
    }

}




	private class RefPackageAndName {
		public java.lang.String name = null;
		public java.lang.String qualifiedName = null;
		public boolean imported = false;
		public javax.jmi.reflect.RefPackage refPackage = null;
		public RefPackageAndName(java.lang.String name, java.lang.String qualifiedName, boolean imported, javax.jmi.reflect.RefPackage refPackage) {
			this.name = name;
			this.qualifiedName = qualifiedName;
			this.imported = imported;
			this.refPackage = refPackage;
		}
	}

	private class RefClassAndName {
		public java.lang.String name = null;
		public java.lang.String qualifiedName = null;
		public javax.jmi.reflect.RefClass refClass = null;
		public RefClassAndName(java.lang.String name, java.lang.String qualifiedName, javax.jmi.reflect.RefClass refClass) {
			this.name = name;
			this.qualifiedName = qualifiedName;
			this.refClass = refClass;
		}
	}

	private class RefAssociationAndName {
		public java.lang.String name = null;
		public java.lang.String qualifiedName = null;
		public javax.jmi.reflect.RefAssociation refAssociation = null;
		public RefAssociationAndName(
			java.lang.String name,
			java.lang.String qualifiedName,
			javax.jmi.reflect.RefAssociation refAssociation) {
			this.name = name;
			this.qualifiedName = qualifiedName;
			this.refAssociation = refAssociation;
		}
	}

	transient private java.util.List ___refPackages= null;
	transient private java.util.List ___refClasses = null;
	transient private java.util.List ___refAssociations = null;


	/**
	 * @see javax.jmi.reflect.RefPackage#refClass(RefObject)
	 */
	public RefClass refClass(RefObject type) {
		if (type instanceof javax.jmi.model.Classifier) {
			return refClass(((javax.jmi.model.Classifier) type).getName());
		} else {
			throw new javax.jmi.reflect.InvalidCallException(type,null,"refClass()");
		}
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refClass(String)
	 */
	public RefClass refClass(String typeName) {
		initialize();
		if (typeName == null) {
			throw new javax.jmi.reflect.InvalidCallException(typeName, null, "refClass()");
		}
		RefClass rc = null;
		RefClassAndName rcan = null;
		if (typeName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			// search with qualified name
			Iterator i = ___refClasses.iterator();
			while (i.hasNext() && rcan == null) {
				RefClassAndName rcanTemp = (RefClassAndName) i.next();
				if (typeName.equals(rcanTemp.qualifiedName)) {
					rcan = rcanTemp;
				}
			}
		} else {
			// search with name 
			Iterator i = ___refClasses.iterator();
			while (i.hasNext() && rcan == null) {
				RefClassAndName rcanTemp = (RefClassAndName) i.next();
				if (typeName.equals(rcanTemp.name)) {
					rcan = rcanTemp;
				}
			}
		}
		if (rcan != null) {
			if (rcan.refClass == null) {
				rcan.refClass = ___repository.refClassM1(rcan.qualifiedName);
				if (rcan.refClass != null) {
					initInstance(rcan.refClass, rcan.qualifiedName);
				}
			}
			rc = rcan.refClass;
		}
		// not found -> search in packages below in case of qualified name
		if (rc == null) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rc == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (typeName.indexOf(rpanTemp.qualifiedName) == 0) {
					getRefPackage(rpanTemp);
					javax.jmi.reflect.RefClass rcTemp = rpanTemp.refPackage.refClass(typeName);
					if (rcTemp != null) {
						rc = rcTemp;
					}
				}
			}
		}	


		if (rc == null) {
			throw new javax.jmi.reflect.InvalidNameException(typeName, null);
		}
		return rc;
 	}

	private void initInstance(java.lang.Object instance, String qualifiedName) {
		if (instance != null && instance instanceof com.sap.ip.mmr.m1layer.IMMRObject) {
			com.sap.ip.mmr.m1layer.IMMRObject mmro = (com.sap.ip.mmr.m1layer.IMMRObject) instance;
			mmro.set___ImmediatePackage(this);
			mmro.set___QualifiedNameImmediatePackage(___qualifiedName);
			mmro.set___QualifiedName(qualifiedName);
			mmro.set___Instantiator(this);
			mmro.set___Repository(___repository);
			mmro.set___State(com.sap.ip.mmr.StateEnum.STATE_NEW);
		}
	}


	/**
	 * @see javax.jmi.reflect.RefPackage#refPackage(RefObject)
	 */
	public javax.jmi.reflect.RefPackage refPackage(RefObject ro) {
		final String method = "refPackage(RefObject ro)"; //$NON-NLS-1$
		javax.jmi.reflect.RefPackage rp = null;
		if (ro instanceof javax.jmi.model.ModelElement) {
			rp =
				refPackage(
					com.sap.ip.mmr.foundation.Utilities.getUtilities().encodeQualifiedName(
						((javax.jmi.model.ModelElement) ro).getQualifiedName()));
		} else {
			com.sap.ip.mmr.Repository.getCategory().errorT(___location, method, com.sap.ip.mmr.foundation.MMRResourceAccessor.getInstance().getMessageText(___repository.getConnection(), "0000")); //$NON-NLS-1$
			throw new javax.jmi.reflect.InvalidCallException(ro,null,"refPackage()");
		}
		return rp;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refPackage(String)
	 */
	public javax.jmi.reflect.RefPackage refPackage(String packageName) {
		initialize();
		if (packageName == null) {
			throw new javax.jmi.reflect.InvalidCallException(packageName, null, "refPackage()");
		}

		javax.jmi.reflect.RefPackage rp = null;


		// search for match
		RefPackageAndName rpan = null;
		if (packageName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rpan == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (packageName.equals(rpanTemp.qualifiedName)) {
					rpan = rpanTemp;
				}
			}
		} else {
			// search with name 
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rpan == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (packageName.equals(rpanTemp.name)) {
					rpan = rpanTemp;
				}
			}
		}
		if (rpan != null) {
			rp = getRefPackage(rpan);
		}

		// not found -> search in packages below in case of qualified name
		if (rp == null) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && rp == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (packageName.indexOf(rpanTemp.qualifiedName) == 0) {
					getRefPackage(rpanTemp);
					javax.jmi.reflect.RefPackage rpTemp = rpanTemp.refPackage.refPackage(packageName);
					if (rpTemp != null) {
						rp = rpTemp;
					}
				}
			}
		}

        // check top level package
        if (rp == null && packageName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0 && this != ___repository.getTopLevelPackageM1()) {
        	rp = ___repository.getTopLevelPackageM1().refPackage(packageName);
        }

		// THIS CODING IN RefPackageImpl ONLY !!!!
		if (rp == null) {
			// not generated package
			rp = new com.sap.ip.mmr.m1layer.RefPackageImpl(___repository);
			((com.sap.ip.mmr.m1layer.RefPackageImpl) rp).set___QualifiedName(packageName);
			javax.jmi.reflect.RefPackage ip = null;
			javax.jmi.model.MofPackage mp = (javax.jmi.model.MofPackage) refMetaObject();
			if (mp != null) {
				javax.jmi.model.Namespace container = mp.getContainer();
				if (container == null || container.equals(___repository.getMofPackageRootM2())) {
					ip = null;
				} else {
					ip = this;
				}
			}
			((com.sap.ip.mmr.m1layer.RefPackageImpl) rp).set___ImmediatePackage(ip);
		}

		if (rp == null) {
			throw new javax.jmi.reflect.InvalidNameException(packageName, null);
		}
		return rp;
	}

	private javax.jmi.reflect.RefPackage getRefPackage(RefPackageAndName rpan) {
		if (rpan.refPackage == null) {
			if (rpan.imported) {
				//rpan.refPackage = ___repository.getTopLevelPackageM1().refPackage(rpan.qualifiedName);
				rpan.refPackage = ___repository.refPackageM1(rpan.qualifiedName);
				initInstance(rpan.refPackage, rpan.qualifiedName);
			} else {
				// create new one
				rpan.refPackage = ___repository.refPackageM1(rpan.qualifiedName);
				initInstance(rpan.refPackage, rpan.qualifiedName);
			}
		}
		return rpan.refPackage;
	}


	/**
	 * @see javax.jmi.reflect.RefPackage#refAssociation(RefObject)
	 */
	public RefAssociation refAssociation(RefObject association) {
		if (association instanceof javax.jmi.model.Association) {
			return refAssociation(((javax.jmi.model.Association) association).getName());
		} else {
			throw new javax.jmi.reflect.InvalidCallException(association, null, "refAssociation()");
		}
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAssociation(String)
	 */
	public RefAssociation refAssociation(String associationName) {
		initialize();
		if (associationName == null) {
			throw new javax.jmi.reflect.InvalidCallException(associationName, null, "refAssociation()");
		}
		RefAssociation ra = null;
		RefAssociationAndName raan = null;
		if (associationName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			// search with qualified name
			Iterator i = ___refAssociations.iterator();
			while (i.hasNext() && raan == null) {
				RefAssociationAndName raanTemp = (RefAssociationAndName) i.next();
				if (associationName.equals(raanTemp.qualifiedName)) {
					raan = raanTemp;
				}
			}
		} else {
			// search with name 
			Iterator i = ___refAssociations.iterator();
			while (i.hasNext() && raan == null) {
				RefAssociationAndName raanTemp = (RefAssociationAndName) i.next();
				if (associationName.equals(raanTemp.name)) {
					raan = raanTemp;
				}
			}
		}
		if (raan != null) {
			if (raan.refAssociation == null) {
				raan.refAssociation = ___repository.refAssociationM1(raan.qualifiedName);
				if (raan.refAssociation != null) {
					initInstance(raan.refAssociation, raan.qualifiedName);
				}
			}
   		    ra = raan.refAssociation;

			// set the association
			if (raan.refAssociation instanceof IMMRAssociation) {
				((IMMRAssociation) raan.refAssociation).setAssociationImpl(get___AssociationsContainer());
			}
			// must be set AFTER the qualified name
			if (raan.refAssociation instanceof com.sap.ip.mmr.m2layer.model.RefAssociationImpl) {
				((com.sap.ip.mmr.m2layer.model.RefAssociationImpl) raan.refAssociation).setAssociationImpl(
					get___AssociationsContainer());
			}
		}
		// not found -> search in packages below in case of qualified name
		if (ra == null) {
			// search with qualified name
			Iterator i = ___refPackages.iterator();
			while (i.hasNext() && ra == null) {
				RefPackageAndName rpanTemp = (RefPackageAndName) i.next();
				if (associationName.indexOf(rpanTemp.qualifiedName) == 0) {
					getRefPackage(rpanTemp);
					javax.jmi.reflect.RefAssociation raTemp = rpanTemp.refPackage.refAssociation(associationName);
					if (raTemp != null) {
						ra = raTemp;
					}
				}
			}
		}	
		if (ra == null) {
			throw new javax.jmi.reflect.InvalidNameException(associationName, null);
		}
		return ra;
	}

	public com.sap.ip.mmr.foundation.AssociationsContainer get___AssociationsContainer() {
		return ((IMMRObject)(___repository
			.getTopLevelPackageM1()))
			.get___AssociationsContainer();
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAllPackages()
	 */
	public Collection refAllPackages() {
		initialize();
		java.util.List list = new java.util.LinkedList();
		Iterator i = ___refPackages.iterator();
		while (i.hasNext()) {
			RefPackageAndName rpan = (RefPackageAndName) i.next();
			javax.jmi.reflect.RefPackage rp = rpan.refPackage;
			if (rp == null) {
				rp = refPackage(rpan.name);
			}
			list.add(rp);
		}
		return list;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAllClasses()
	 */
	public Collection refAllClasses() {
		initialize();
		java.util.List list = new java.util.LinkedList();
		Iterator i = ___refClasses.iterator();
		while (i.hasNext()) {
			RefClassAndName rcan = (RefClassAndName) i.next();
			javax.jmi.reflect.RefClass rc = rcan.refClass;
			if (rc == null) {
				rc = refClass(rcan.name);
			}
			list.add(rc);
		}
		return list;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refAllAssociations()
	 */
	public Collection refAllAssociations() {
		initialize();
		java.util.List list = new java.util.LinkedList();
		Iterator i = ___refAssociations.iterator();
		while (i.hasNext()) {
			RefAssociationAndName raan = (RefAssociationAndName) i.next();
			javax.jmi.reflect.RefAssociation ra = raan.refAssociation;
			if (ra == null) {
				ra = refAssociation(raan.name);
			}
			list.add(ra);
		}
		return list;
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refCreateStruct(RefObject, List)
	 */
	public RefStruct refCreateStruct(RefObject struct, List params) throws javax.jmi.reflect.TypeMismatchException {
		if (struct instanceof javax.jmi.model.Classifier) {
			return refCreateStruct(((javax.jmi.model.Classifier) struct).getName(), params);
		} else {
			throw new javax.jmi.reflect.InvalidCallException(struct, null, "refCreateStruct()");
		}
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refCreateStruct(String, List)
	 */
	public RefStruct refCreateStruct(String structName, List params) throws javax.jmi.reflect.TypeMismatchException {
		String sn = structName;
		// create a new instance and run the appropriate constructor
		if (structName.indexOf(IRepositoryConst.M2PackageDelimiter) > 0) {
			sn = structName;
		} else {
			sn = ___qualifiedName + IRepositoryConst.M2PackageDelimiter + structName;
		}
		return ___repository.refCreateStructM1(sn, params);
	}

	/**
	 * @see javax.jmi.reflect.RefPackage#refGetEnum(RefObject, String)
	 */
	public RefEnum refGetEnum(RefObject enum, String name) {
		if (enum instanceof javax.jmi.model.EnumerationType) {
			return refGetEnum(((javax.jmi.model.EnumerationType) enum).getName(), name);
		} else {
			RefObject mo = enum.refMetaObject();
			if (mo != null && mo instanceof javax.jmi.model.ModelElement) {
				String nameEnum = ((javax.jmi.model.ModelElement) mo).getName();
				return refGetEnum(nameEnum, name);
			}
		}
		return null;
	}


	/**
	 * @see javax.jmi.reflect.RefPackage#refDelete()
	 */
	public void refDelete() {
		___repository.refDeleteM1(this);
		___refPackages.clear();
		___refClasses.clear();
		___refAssociations.clear();
	}



}
