/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/rc/RCField.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.rc;

import java.util.Iterator;

import com.sap.tc.jtools.util.structures.StructureTree;

/**
 * @author D037913
 */
class RCField implements RCConstants{

  private RCStatusInfo statusInfo;
  private String name;

  public RCField(StructureTree fieldTree, RCClass parent) {
    name = fieldTree.getParameter(ATTR_NAME);
    this.statusInfo = new RCStatusInfo(fieldTree, parent.getStatusInfo());
  }

  public RCField(String name, RCStatusInfo statusInfo) {
    this.name = name;
    this.statusInfo = statusInfo;
  }

  /**
   * @return
   */
  public String getName() {
    return name;
  }

  /**
   * @return
   */
  public RCStatusInfo getStatusInfo() {
    return statusInfo;
  }

  public RCStatusInfo getStatusInfo(String caller, String[] callee) {
    for (Iterator iter = statusInfo.getAuthUsers().iterator();
      iter.hasNext();
      ) {
      if (caller.startsWith((String) iter.next())) {
        return statusInfo.getOKInfo();
      }
    }
    return statusInfo;
  }

}


