/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/performance/LoopTest.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.performance;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssignment;
import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IDoStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IName;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;

/**
 * This JLin test checks temporary objects are instantiated in a loop body.
 * 
 * @author d037913
 */
public class LoopTest extends JomTestVisitor {

  public static final String NAME = "Instantiation in loop";
  private static final String MSG_KEY_1 = "loop.1";

  private Stack assignmentStack = new Stack();

  private Stack loopLocalVars = new Stack();

  private void addError(Position pos) {
    addError(MSG_KEY_1, null, pos);
  }

  private void checkAssignments() {
    List assgnmnts = (List) assignmentStack.peek();
    for (Iterator iter = assgnmnts.iterator(); iter.hasNext();) {
      addError((Position) iter.next());
    }
  }

  public void endVisit(IDoStatement node) {
    checkAssignments();
    assignmentStack.pop();
    loopLocalVars.pop();
  }

  public void endVisit(IForStatement node) {
    checkAssignments();
    assignmentStack.pop();
    loopLocalVars.pop();
  }

  public void endVisit(IWhileStatement node) {
    checkAssignments();
    assignmentStack.pop();
    loopLocalVars.pop();
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.JomTestVisitor#getTestName()
   */
  public String getTestName() {
    return NAME;
  }

  public boolean visit(IAssignment node) {
    if (assignmentStack.isEmpty()
      || !(node.getLeftHandSide() instanceof IName)
      || !(node.getRightHandSide() instanceof IClassInstanceCreation))
      return true;
    IBinding bnd = ((IName) node.getLeftHandSide()).resolveBinding();
    if (bnd instanceof IVariableBinding) {
      IVariableBinding varBnd = (IVariableBinding) bnd;
      // check if var is local
      if (varBnd.isField())
        return true;
      List localVars = (List) loopLocalVars.peek();
      for (Iterator iter = localVars.iterator(); iter.hasNext();) {
        IVariableBinding localVarBnd = (IVariableBinding) iter.next();
        if (localVarBnd.equals(bnd)) {
          ((List) (assignmentStack).peek()).add(node);
        }
      }
    }
    return true;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IDoStatement)
   */
  public boolean visit(IDoStatement node) {
    assignmentStack.push(new ArrayList());
    loopLocalVars.push(new ArrayList());
    return true;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IForStatement)
   */
  public boolean visit(IForStatement node) {
    assignmentStack.push(new ArrayList());
    loopLocalVars.push(new ArrayList());
    return true;
  }

  public boolean visit(IMethodInvocation node) {
    if (assignmentStack.isEmpty() || node.arguments().size() == 0)
      return true;
    List args = node.arguments();
    List assignments = (List) assignmentStack.peek();
    for (Iterator iterator = assignments.iterator(); iterator.hasNext();) {
      IAssignment assgn = (IAssignment) iterator.next();
      for (Iterator argIt = args.iterator(); argIt.hasNext();) {
        Object arg = argIt.next();
        if (arg instanceof IName) {
          if (((IName) assgn.getLeftHandSide())
            .resolveBinding()
            .equals(((IName) arg).resolveBinding())) {
            // heuristics: if the variable is used as a method parameter,
            // we assume it's not loop-temporary and remove it from the list
            iterator.remove();
          }
        }
      }
    }
    return true;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationFragment)
   */
  public boolean visit(IVariableDeclarationStatement node) {
    if (loopLocalVars.isEmpty())
      return true;
    ((List) (loopLocalVars.peek())).add(node.resolveBinding());
    return true;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement)
   */
  public boolean visit(IWhileStatement node) {
    assignmentStack.push(new ArrayList());
    loopLocalVars.push(new ArrayList());
    return true;
  }

}
