/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/metrics/StatementsPerMethod.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.metrics;

import java.util.Iterator;
import java.util.List;

import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.Metric;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import com.sap.tc.jtools.util.collections.IntStack;

/**
 * @author D037913
 */
public class StatementsPerMethod extends JomMetricVisitor {

  private static final String METRIC_NAME = "statements";

  /** keep in sync with tests.xml! */
  private static final String NAME = "Statements per method";

  private IntStack counterStack = new IntStack();

  public StatementsPerMethod() {
  }

  public void endVisit(IMethodDeclaration node) {
    if (counterStack.isEmpty())
      return;
    addMetricValue(METRIC_NAME, counterStack.pop(), node);
  }

  protected MetricInfo[] getMetricInfos() {
    return new MetricInfo[] {
       new MetricInfo(
        METRIC_NAME,
        MetricInfo.AVERAGE | MetricInfo.MAX | MetricInfo.STD_DEV)};
  }

  public String getTestName() {
    return NAME;
  }

  private void incrementCounter(int i) {
    if (counterStack.isEmpty())
      return;
    counterStack.push(counterStack.pop() + i);
  }

  public boolean visit(IBlock node) {
    incrementCounter(node.statements().size());
    return true;
  }

  public boolean visit(IForStatement node) {
    if (node.getBody() instanceof IBlock)
      return true;
    incrementCounter(1);
    return true;
  }

  public boolean visit(IIfStatement node) {
    if (!(node.getThenStatement() instanceof IBlock))
      incrementCounter(1);
    IStatement elseStmt = node.getElseStatement();
    if (elseStmt != null && !(elseStmt instanceof IBlock))
      incrementCounter(1);
    return true;
  }

  public boolean visit(IMethodDeclaration node) {
    counterStack.push(0);
    return true;
  }

  public boolean visit(ISwitchStatement node) {
    List stmts = node.statements();
    for (Iterator iter = stmts.iterator(); iter.hasNext();) {
      if (!(iter.next() instanceof IBlock))
        incrementCounter(1);
    }
    return true;
  }

  public boolean visit(IWhileStatement node) {
    if (node.getBody() instanceof IBlock)
      return true;
    incrementCounter(1);
    return true;
  }

}
