/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/metrics/HierarchyDepth.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.metrics;

import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.Metric;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;

/**
 * @author D037913
 */
public class HierarchyDepth extends JomMetricVisitor {

  /** keep in sync with tests.xml! */

  private static final String NAME = "Inheritance Hierarchy Depth";
  private static final String METRIC_NAME = "hierarchydepth";

  public String getTestName() {
    return NAME;
  }

  public HierarchyDepth() {
    super();
  }

  protected MetricInfo[] getMetricInfos() {
    return new MetricInfo[] {
       new MetricInfo(
        METRIC_NAME,
        MetricInfo.AVERAGE | MetricInfo.MAX | MetricInfo.STD_DEV)};
  }

  public boolean visit(ITypeDeclaration node) {
    int depth = getDepth(node.resolveBinding(), 0);
    addMetricValue(METRIC_NAME, depth, node);
    return true;
  }

  private int getDepth(IReferenceTypeBinding bnd, int counter) {
    if (bnd.getSuperclass() != null) {
      return getDepth(bnd.getSuperclass(), ++counter);
    }
    return counter;
  }

}
