/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/metrics/ClassCounter.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.metrics;

import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;

public class ClassCounter extends JomMetricVisitor {

  public static final String TEST_NAME = "Global Counters"; //$NON-NLS-1$

  private static final String CLASS_METRIC = "Classes";
  private static final String METHOD_METRIC = "Methods";
  private static final String LINE_METRIC = "Lines of Code";

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.JomTestVisitor#getTestName()
   */
  public String getTestName() {
    return TEST_NAME;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration)
   */
  public boolean visit(IMethodDeclaration node) {
    addMetricValue(METHOD_METRIC, 1.0f, node);
    return false;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration)
   */
  public boolean visit(ITypeDeclaration node) {
    addMetricValue(CLASS_METRIC, 1.0f, node);
    return true;
  }

  protected MetricInfo[] getMetricInfos() {
    return new MetricInfo[] {
      new MetricInfo(CLASS_METRIC, MetricInfo.SUM),
      new MetricInfo(METHOD_METRIC, MetricInfo.SUM),
      new MetricInfo(LINE_METRIC, MetricInfo.SUM)};
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit)
   */
  public boolean visit(ICompilationUnit node) {
    addMetricValue(LINE_METRIC, node.lineCount(), node);
    return true;
  }

}
