/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/metrics/ArgumentsPerMethod.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.metrics;

import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.Metric;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;

/**
 * @author D037913
 *
 */
public class ArgumentsPerMethod extends JomMetricVisitor {

  /** keep in sync with tests.xml! */

  private static final String NAME = "Arguments per method";
  private static final String METRIC_NAME = "arguments";

  public String getTestName() {
    return NAME;
  }

  public ArgumentsPerMethod() {
    super();
  }

  protected MetricInfo[] getMetricInfos() {
    return new MetricInfo[] {
       new MetricInfo(
        METRIC_NAME,
        MetricInfo.AVERAGE | MetricInfo.MAX | MetricInfo.STD_DEV)};
  }

  public boolean visit(IMethodDeclaration node) {
    if (node.isConstructor())
      // constructors are not measured
      return true;
    addMetricValue(METRIC_NAME, node.parameters().size(), node);
    return true;
  }

}
