/*
 * Created on 13.03.2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.tc.jtools.jlint.tests.logging;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.FieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;




/**
 * @author d028440
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LoggingTracingSeverityCheck extends JomTestVisitor {
	
	private class BlockInfo{
		private boolean m_errorTraceDetected;
		private boolean m_existCorrespondingThrow;
		private int     m_errorTracePos;
		private int     m_throwPos;
		private IMethodInvocation m_traceInvocation;
		
		BlockInfo() {
			m_errorTraceDetected = false;
			m_existCorrespondingThrow = false;
			m_errorTracePos = LoggingTracingSeverityCheck.DEFAULT_POS;
			m_throwPos = LoggingTracingSeverityCheck.DEFAULT_POS;
			m_traceInvocation = null;
		}
	}
	
	/** keep in sync with tests.xml! */


	private static final String NAME = "Logging Severities Check";
	private static final String FATAL_SEVERITY_NAME   = "FATAL";
	private static final String ERROR_SEVERITY_NAME   = "ERROR";
	private static final String WARNING_SEVERITY_NAME = "WARNING";
	private static final String INFO_SEVERITY_NAME    = "INFO";
	private static final String PATH_SEVERITY_NAME    = "PATH";
	private static final String DEBUG_SEVERITY_NAME   = "DEBUG";
	private static final String LOCATION = "com.sap.tc.logging.Location";
	private static final String CATEGORY = "com.sap.tc.logging.Category";	
	private static final String MSG_KEY_1 = "LoggingCheck.1";
	private static final String MSG_KEY_2 = "LoggingCheck.2";
	private static final String MSG_KEY_3 = "LoggingCheck.3";
	private static final String MSG_KEY_4 = "LoggingCheck.4";	
	private static final short STATEMENT_DIST;
	private static final short DEFAULT_POS;
	private Stack m_blockInfoStack;
	private BlockInfo m_blockInfo;
	private boolean m_inCatchClause;
	
	public String getTestName() {
		return NAME;
	}
	
	public LoggingTracingSeverityCheck(){
		m_blockInfo = null;
		m_blockInfoStack = new Stack();
		m_inCatchClause = false;
	}
	
	static {
		STATEMENT_DIST = 2;
		DEFAULT_POS = -1;
	}

	private void scrutinizeMethodInvocation(IMethodInvocation node){
		String propVal = node.getName();
		if (isLogOrTraceMethodWithoutSeverity(node.getName())){
			checkSeverity(node);
		}
		if (isTraceMethodWithSeverity(node.getName())){
			checkLogControllerBinding(node, true);
		}
		if (isLogMethodWithSeverity(node.getName())){
			checkLogControllerBinding(node, false);
		}
	}
	
	private void checkLogControllerBinding(IMethodInvocation node, boolean isTrace){
		Properties props = new Properties();
		String nodeName = node.getName();
		props.put("methodName", nodeName);
		IMethodBinding methBnd = node.resolveMethodBinding();
		IReferenceTypeBinding declClass = methBnd.getDeclaringClass();
		if (InheritanceTool.bndExtends(declClass, LOCATION) && !isTrace) {
			if(isErrorTraceMethodCall(node)){
				m_blockInfo.m_errorTraceDetected = true;
				m_blockInfo.m_traceInvocation = node;
				m_blockInfo.m_errorTracePos = node.getStartPosition();
			}
			else{
				addError(MSG_KEY_3, props, node);
			}
		}
			
		if (InheritanceTool.bndExtends(declClass, CATEGORY) && isTrace){
			addError(MSG_KEY_4, props, node);
		}
	}
	
	private boolean isErrorTraceMethodCall(IMethodInvocation node){
		return node.getName().equals("error") || node.getName().equals("errorT");
	}
		
	private boolean isLogOrTraceMethodWithoutSeverity(String methodName){
		return methodName.equals("logT") || 
			   methodName.equals("log")  ||
			   methodName.equals("traceThrowableT") ||
			   methodName.equals("logThrowableT") ||
			   methodName.equals("logThrowable");
			   
	}
	
	private boolean isTraceMethodWithSeverity(String methodName){
		return  methodName.equals("path")     ||
				methodName.equals("pathT")    ||	
				methodName.equals("debug")    ||	
				methodName.equals("debugT");	
	}
	
	private boolean isLogMethodWithSeverity(String methodName){
		return methodName.equals("fatal")    ||
			   methodName.equals("fatalT")   ||
			   methodName.equals("errorT")   ||
			   methodName.equals("error")    ||
			   methodName.equals("warning")  ||	
			   methodName.equals("warningT");
	}  
	
	private void checkSeverity(IMethodInvocation node){
		IMethodBinding methBnd = node.resolveMethodBinding();
		IReferenceTypeBinding declClass = methBnd.getDeclaringClass();
		if (InheritanceTool.bndExtends(declClass, LOCATION)) {
			checkTraceWriting(node);
		}
			
		if (InheritanceTool.bndExtends(declClass, CATEGORY)){
			checkLogWriting(node);
		}
	}

	private void printErrorString(String key, Properties p, String propName, String propVal, IMethodInvocation node) {
		p.setProperty(propName, propVal);
		addError(key, p, node);
	}
	
	private void checkTraceWriting(IMethodInvocation node){
		Properties msgProps = new Properties();
		List paras = node.arguments();
		if (!paras.isEmpty()) {
			Object o = paras.get(0);

			if (o instanceof IFieldAccess) {
				IFieldAccess fa = (FieldAccess) o;
				String val = null;
				if (fa != null) {
					val = fa.getName();
					if (val.equals(FATAL_SEVERITY_NAME)) {
						printErrorString(MSG_KEY_1, msgProps, "severity", "FATAL", node);
					}
					if (val.equals(ERROR_SEVERITY_NAME)) {
						m_blockInfo.m_errorTraceDetected = true;
						m_blockInfo.m_traceInvocation = node;
						m_blockInfo.m_errorTracePos = node.getStartPosition();
					}
					if (val.equals(WARNING_SEVERITY_NAME)) {
						printErrorString(MSG_KEY_1, msgProps, "severity", "WARNING", node);
					}
					/*
					if (val.equals(INFO_SEVERITY_NAME)) {
						printErrorString(MSG_KEY_1, msgProps, "severity", "INFO", node);
					}
					*/
				}
			}
		}
	}

	private void checkLogWriting(IMethodInvocation node){
		Properties msgProps = new Properties();
		List paras = node.arguments();
		if (!paras.isEmpty()) {
			Object o = paras.get(0);

			if (o instanceof IFieldAccess) {
				IFieldAccess fa = (FieldAccess) o;
				String val = null;
				if (fa != null) {
					val = fa.getName();
					if (val.equals(DEBUG_SEVERITY_NAME)) {
						printErrorString(MSG_KEY_2, msgProps, "severity", "DEBUG", node);
					}
					if (val.equals(PATH_SEVERITY_NAME)) {
						printErrorString(MSG_KEY_2, msgProps, "severity", "PATH", node);
					}
				}
			}
		}
	}
	
	private void visitImpl(List stmts, BlockInfo bi){
		Iterator i = stmts.iterator();
		
		while (i.hasNext() ){
			Object o = i.next();
			if (o instanceof IStatement){
				IStatement stmt = (IStatement)o;
				if (stmt instanceof IExpressionStatement){
					IExpressionStatement exStmt = (IExpressionStatement)stmt;
					IExpression ex = exStmt.getExpression();
				
					if (ex instanceof IMethodInvocation){
						IMethodInvocation methInv = (IMethodInvocation)ex;
						scrutinizeMethodInvocation(methInv);
					}
				}
			
				if (stmt instanceof IThrowStatement){
					m_blockInfo.m_throwPos = ((IThrowStatement)stmt).getStartPosition();
					m_blockInfo.m_existCorrespondingThrow = true;
				}
			}
		}
		
	}
	
	private void endVisitImpl(){
		m_blockInfo = (BlockInfo)m_blockInfoStack.pop();
		if (m_blockInfo.m_errorTraceDetected){
			Properties p = new Properties();
			//if there is neither a throw statement preceding an error trace nor the
			//error trace is in a catch clause a message is printed
			if (!(m_blockInfo.m_existCorrespondingThrow || m_inCatchClause)){
				printErrorString(MSG_KEY_1, p, "severity", "ERROR", m_blockInfo.m_traceInvocation);				
			}
			//check whether the corresponding throw statement is close enough to the
			//trace to count as "corresponding"
			else if (m_blockInfo.m_existCorrespondingThrow && !m_inCatchClause){
				int throwLine = currentCompilationUnit.lineNumber(m_blockInfo.m_throwPos);
				int errorTraceLine = currentCompilationUnit.lineNumber(m_blockInfo.m_errorTracePos);
				if (Math.abs(throwLine - errorTraceLine) > STATEMENT_DIST){
					printErrorString(MSG_KEY_1, p, "severity", "ERROR", m_blockInfo.m_traceInvocation);
				}			
			}
		}			
	}
	
	
	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IBlock)
	 */
	public boolean visit(IBlock node) {
		m_blockInfo = new BlockInfo();
		List stmts = node.statements();
		
		visitImpl(stmts, m_blockInfo);
		
		m_blockInfoStack.push(m_blockInfo);
		
		return true;
	}
	
	
	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#endVisit(com.sap.tc.jtools.jlint.jom.interfaces.IBlock)
	 */
	public void endVisit(IBlock node) {
		endVisitImpl();
	}
	
	
	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#endVisit(com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause)
	 */
	public void endVisit(ICatchClause node) {
		m_inCatchClause = false;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause)
	 */
	public boolean visit(ICatchClause node) {
		m_inCatchClause = true;
		return true;
	}

}
