/*
 * @(#)LoggingCodeSeverityCheck.java 7.0 2004-10-4
 * 
 * Copyright (c) 2002 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 */
package com.sap.tc.jtools.jlint.tests.logging;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;

/**
 * This test checks for accessing System.out and System.err fields.
 * 
 * @version 7.0 - 2004-10-4
 * @author i030725
 */
public class LoggingStandardOutputs extends JomTestVisitor {

  private static final String SYSTEM_CLASS_NAME = System.class.getName();
  private static final String FIELD_OUT = "out";
  private static final String FIELD_ERR = "err";

  private static final String MSG_KEY_1 = "sysouterr.1";
	private static final String MSG_KEY_2 = "sysouterr.2";

  /* keep in sync with tests.xml! */

  private static final String NAME = "Logging Standard Outputs";

  public String getTestName() {
    return NAME;
  }

  /**
   * Check if the access field is <code>err</code> or <code>out</code> from
   * class <code>java.lang.String</code>.
   * 
   * @param node
   * @return
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess)
   */
  public boolean visit(IFieldAccess node) {
    String fieldName = node.getName();
    IVariableBinding binding = node.resolveBinding();
    ITypeBinding declaringClass = binding.getDeclaringClass();
    if (declaringClass == null) {
      // array.length has no declaring class
      return true;   
    }
    String className = declaringClass.getName();

    if (className.equals(SYSTEM_CLASS_NAME)) {
      if (fieldName.equals(FIELD_OUT)) {
        addError(MSG_KEY_1, null, node);
      } else if (fieldName.equals(FIELD_ERR)) {
        addError(MSG_KEY_2, null, node);
      }
    }
    return true;
  }

}
