/*
 * @(#)LoggingConsoleLog.java 7.0 2004-10-12
 * 
 * Copyright (c) 2002 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 */
package com.sap.tc.jtools.jlint.tests.logging;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;

/**
 * This test checks for illegal using of ConsoleLog for logging.
 * 
 * @version 7.0 - 2004-10-12
 * @author i030725
 */
public class LoggingConsoleLog extends JomTestVisitor {
  private static final String CONSOLE_LOG = "com.sap.tc.logging.ConsoleLog";
  private static final String MSG_KEY_1 = "consolelog.1";

  /* keep in sync with tests.xml! */

  private static final String NAME = "Logs in ConsoleLog";

  public String getTestName() {
    return NAME;
  }

	/**
	 * Checks if this class instance creation is of the <code>ConsoleLog</code>.
	 * If true generates error message.
	 * @param node
	 * @return
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation)
	 */
	public boolean visit(IClassInstanceCreation node) {
		IMethodBinding constructorBinding = node.resolveConstructorBinding();
		IReferenceTypeBinding declaringClass =
			constructorBinding.getDeclaringClass();
		if (InheritanceTool.bndExtends(declaringClass, CONSOLE_LOG)) {
			addError(MSG_KEY_1, null, node);
		}
		return true;
	}
	
}
