/*
 * @(#)LoggingConfiguring.java 7.0 2004-10-12
 * 
 * Copyright (c) 2002 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 */
package com.sap.tc.jtools.jlint.tests.logging;

import java.util.Properties;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;

/**
 * This test checks for unallowable configuring of logging.
 * 
 * @version 7.0 - 2004-10-12
 * @author i030725
 */
public class LoggingConfiguring extends JomTestVisitor {

  private static final String LOG_CONTROLLER_CLASS = "com.sap.tc.logging.LogController";

	private static final String METHOD_NAME = "method";
  private static final String MSG_KEY_1 = "logconfig.1";

  private static final String[] LOG_CONTROLLER_METHODS =
    {
      "addFilter",
      "addLocalLog",
      "addLog",
      "addPrivateLog",
      "removeFilter",
      "removeFilters",
      "removeLog",
      "removeLogs",
      "setEffectiveSeverity",
      "setMaximumSeverity",
      "setMinimumSeverity",
      "setName",
      "setResourceBundleName" };

  /* keep in sync with tests.xml! */

  private static final String NAME = "Configuring Logging";

  public String getTestName() {
    return NAME;
  }

  /**
   * 
   */
  public LoggingConfiguring() {
    super();
  }

  /**
   * Check for methods that configuring logging and
   * generate errors for such invocations.
   * @param node
   * @return
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation)
   */
  public boolean visit(IMethodInvocation node) {
    IMethodBinding methodBinding = node.resolveMethodBinding();
    IReferenceTypeBinding typeBinding = methodBinding.getDeclaringClass();
    String methodName = methodBinding.getName();
    Properties properties = new Properties();
    properties.setProperty(METHOD_NAME, methodName);

    if (checkLogControllerMethods(typeBinding, methodName)) {
			addError(MSG_KEY_1, properties, node);
    }

    return true;
  }

	/**
	 * Check if the specified method is configuring method for logging.
	 * 
	 * @param typeBinding the type to which the method belongs
	 * @param methodName the name of the method.
	 * 
	 * @return <code>true</code> if the method is configuring method 
	 * for logging, othrwise <code>false</code>.
	 */
  private boolean checkLogControllerMethods(
    IReferenceTypeBinding typeBinding,
    String methodName) {
    if (InheritanceTool.bndExtends(typeBinding, LOG_CONTROLLER_CLASS)) {
      for (int i = 0; i < LOG_CONTROLLER_METHODS.length; i++) {
        if (methodName.equals(LOG_CONTROLLER_METHODS[i])) {
          return true;
        }
      }
    }

    return false;
  }

}
