/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/language/ReturnArrayTest.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.language;

import java.util.Collection;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.INullLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import com.sap.tc.jtools.util.collections.BooleanStack;

/**
 * This JLin test checks if methods that return array types or 
 * java.util.Collection return null.
 * Instead they should return zero-length arrays or empty collections;
 * this saves the caller of the method from checking the return value for null.
 * 
 * @author d037913
 */
public class ReturnArrayTest extends JomTestVisitor {

	private static final String NAME = "Return Array Test";

	private static final String MSG_KEY_1 = "array.1";
	private static final String MSG_KEY_2 = "array.2";

	private BooleanStack isArrayStack = new BooleanStack();
	private BooleanStack isCollectionStack = new BooleanStack();

	public String getTestName() {
		return NAME;
	}

	public boolean visit(IMethodDeclaration node) {
		IType retType = node.getReturnType();
		boolean isArray = false;
		boolean isCollection = false;
		if (retType != null) {
			ITypeBinding retBnd = retType.resolveBinding();
			isArray = retBnd.isArray();
			isCollection =
				retBnd.isReference()
					&& InheritanceTool.bndImplements(
						(IReferenceTypeBinding) retBnd,
						Collection.class.getName());
		}
		isArrayStack.push(isArray);
		isCollectionStack.push(isCollection);
		return true;
	}

	public void endVisit(IMethodDeclaration node) {
		isArrayStack.pop();
		isCollectionStack.pop();
	}

	public boolean visit(IReturnStatement node) {
		if (!(isArrayStack.peek() || isCollectionStack.peek()))
			return true;
		if (node.getExpression() instanceof INullLiteral) {
			if (isArrayStack.peek()) {
				addError(MSG_KEY_1, null, node);
			} else {
				// must be a collection
				addError(MSG_KEY_2, null, node);
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit)
	 */
	public boolean visit(ICompilationUnit node) {
		// just for safety
		isArrayStack.clear();
		isCollectionStack.clear();
		return true;
	}

}
