/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/language/OneStmtPerLine.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.language;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssertStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IBreakStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IDoStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IEmptyStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ILabeledStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchCase;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISynchronizedStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;

/**
 * @author d034036
 *
 */
public class OneStmtPerLine extends JomTestVisitor {

	/** keep in sync with tests.xml! */

	private static final String NAME = "One Statement Per Line";

	static public final String TWO_STMTS_ON_THE_SAME_LINE = "oneStmt.1"; //$NON-NLS-1$

	private int currentStmtLine = 0;
	private Traversable currentStmt = null;

	public String getTestName() {
		return NAME;
	}

	public boolean visit(IAssertStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IBlock node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IBreakStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IConstructorInvocation node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IContinueStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IDoStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IEmptyStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IExpressionStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IForStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IIfStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(ILabeledStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IReturnStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(ISuperConstructorInvocation node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(ISwitchCase node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(ISwitchStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(ISynchronizedStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IThrowStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(ITryStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(ITypeDeclarationStatement node) {
		updateAndCheck(node);
		return true;
	}

	public boolean visit(IVariableDeclarationStatement node) {
		//	updateAndCheck(node);
		return true;
	}

	public boolean visit(IWhileStatement node) {
		updateAndCheck(node);
		return true;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration)
	 */
	public boolean visit(IFieldDeclaration node) {
	//	updateAndCheck(node);
		return true;
	}

	private void updateAndCheck(Traversable stmt) {
		if (currentStmt == null) { // first stmt
			currentStmt = stmt;
			currentStmtLine =
				currentCompilationUnit.lineNumber(stmt.getStartPosition());
			return;
		}

		if ((stmt.getNodeType() == Traversable.VARIABLE_DECLARATION_STATEMENT
			|| (stmt.getNodeType() == Traversable.EXPRESSION_STATEMENT
				&& ((IExpressionStatement) stmt).getExpression().getNodeType()
					== Traversable.ASSIGNMENT))
			&& (currentStmt.getNodeType() == Traversable.FOR_STATEMENT
				|| currentStmt.getNodeType() == Traversable.WHILE_STATEMENT)) {
			return;
		}

		if (stmt.getNodeType() == Traversable.BLOCK) {
			currentStmtLine =
				currentCompilationUnit.lineNumber(stmt.getStartPosition());
			currentStmt = stmt;
			return;
		}

		int tempLine =
			currentCompilationUnit.lineNumber(stmt.getStartPosition());
		if (tempLine == currentStmtLine) {
			addError(TWO_STMTS_ON_THE_SAME_LINE, null, stmt);
		}
		currentStmtLine = tempLine;
		currentStmt = stmt;
	}

}
