/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/language/OneClassForCUTest.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.language;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;

/**
 * @author d034036
 *
 */
public class OneClassForCUTest extends JomTestVisitor {

  /** keep in sync with tests.xml! */

  private static final String NAME = "One Top-Level Class Only";
  private int topLevelTypeCounter;

  static public final String TOO_MANY_TOPLEVEL_CLASSES = "oneTopLevelClass.1"; //$NON-NLS-1$

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#endVisit(com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit)
   */
  public void endVisit(ICompilationUnit node) {
    if (topLevelTypeCounter > 1) {
      addError(TOO_MANY_TOPLEVEL_CLASSES, null,node);
    }
  }
  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration)
   */
  public boolean visit(ITypeDeclaration node) {
    if (node.isPackageMemberTypeDeclaration()) {
      topLevelTypeCounter++;
    }
    return true;
  }
  
  public String getTestName() {
    return NAME;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit)
   */
  public boolean visit(ICompilationUnit node) {
    topLevelTypeCounter =0;
    return true;
  }

}
