/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/language/FinalizationTest.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.language;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;

/**
 * This JLin test checks if super.finalize() is called from
 * finalize()
 * 
 * @author d037913
 */
public class FinalizationTest extends JomTestVisitor {

	private static final String NAME = "Finalization Test"; //$NON-NLS-1$

	private static final String MSG_KEY_1 = "finalize.1"; //$NON-NLS-1$
	private static final String MSG_KEY_2 = "finalize.2"; //$NON-NLS-1$
	private static final String MSG_KEY_3 = "finalize.3"; //$NON-NLS-1$
	private static final String FINALIZE_METHOD = "finalize"; //$NON-NLS-1$

	private Stack finalizeMethods = new Stack();

	public String getTestName() {
		return NAME;
	}

	public boolean visit(IMethodDeclaration node) {
		checkFinalize(node);
		return true;
	}

	private void checkFinalize(IMethodDeclaration node) {
		if (FINALIZE_METHOD.equals(node.getName())
			&& node.getReturnType().isSimpleType()
			&& ISimpleType.VOID.equals(
				((ISimpleType) node.getReturnType()).getName()[0])
			&& node.parameters().size() == 0) {
			addError(MSG_KEY_2, null, node);
			if (!Modifier.isProtected(node.resolveBinding().getModifiers())) {
				addError(MSG_KEY_3, null, node);
			}
			Map superFinCalled = new HashMap();
			superFinCalled.put(node, Boolean.FALSE);
			finalizeMethods.push(superFinCalled);
		}
	} /* (non-Javadoc)
	      * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation)
	      */
	public boolean visit(ISuperMethodInvocation node) {
		if (finalizeMethods.isEmpty())
			return true;
		if (FINALIZE_METHOD.equals(node.getName())
			&& node.arguments().size() == 0) {
			Map superFinCalled = (Map) finalizeMethods.peek();
			Iterator iter = superFinCalled.keySet().iterator();
			IMethodDeclaration finalizeMeth = (IMethodDeclaration) iter.next();
			superFinCalled.put(finalizeMeth, Boolean.TRUE);
		}
		return true;
	} /* (non-Javadoc)
	        * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#endVisit(com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation)
	        */
	public void endVisit(IMethodDeclaration node) {
		if (finalizeMethods.isEmpty())
			return;
		Map superFinCalled = (Map) finalizeMethods.peek();
		Iterator iter = superFinCalled.keySet().iterator();
		IMethodDeclaration finalizeMeth = (IMethodDeclaration) iter.next();
		if (finalizeMeth == node) {
			Boolean ok = (Boolean) superFinCalled.get(finalizeMeth);
			if (!ok.booleanValue()) {
				addFinalizeError(node);
			} // reset
			finalizeMethods.pop();
		}
	}

	private void addFinalizeError(Position pos) {
		addError(MSG_KEY_1, null, pos);
	}

}
