/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/language/FinalBlocks.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.language;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;

/**
 * @author d034036
 *  
 */
public class FinalBlocks extends JomTestVisitor {

  /** keep in sync with tests.xml! */
  private static final String NAME = "FinalBlocks";
  static public final String ABORT_FINALLY_BLOCK = "finalblocks.1"; //$NON-NLS-1$
  private Set finallyBlocks = new HashSet();
  private Stack finallyBlockStack = new Stack();

  public String getTestName() {
    return NAME;
  }

  public void endVisit(IBlock node) {
    if (finallyBlocks.contains(node)) {
      finallyBlockStack.pop();
    }
  }

  public boolean visit(IBlock node) {
    if (finallyBlocks.contains(node)) {
      finallyBlockStack.push(node);
    }
    return true;
  }

  public boolean visit(IReturnStatement node) {
    checkIfInFinally(node);
    return true;
  }

  public boolean visit(ITryStatement node) {
    IBlock fnlBlock = node.getFinally();
    if (fnlBlock != null) {
      finallyBlocks.add(fnlBlock);
    }
    return true;
  }

  public boolean visit(IMethodDeclaration node) {
    finallyBlockStack = new Stack();
    return true;
  }

  public boolean visit(IInitializer node) {
    finallyBlockStack = new Stack();
    return true;
  }

  private void checkIfInFinally(Position pos) {
    if (!finallyBlockStack.isEmpty()) {
      addError(ABORT_FINALLY_BLOCK, null, pos);
    }
  }
}
