/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/language/EqualsHashCodeTest.java#3 $
 */

package com.sap.tc.jtools.jlint.tests.language;

import java.lang.reflect.Modifier;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;

/**
 * This JLin test checks if <code>public boolean equals(Object obj)</code> is
 * overridden, <code>public int hashCode()</code> is also overridden.
 * 
 * This is needed in case you want to store objects in a HashTable: to
 * successfully store and retrieve objects from a hashtable, the objects used as
 * keys must implement the hashCode method and the equals method.
 * 
 * @see java.util.Hashtable
 * @author d037913
 */

public class EqualsHashCodeTest extends JomTestVisitor {

	public static final String NAME = "Equals/HashCode Test";

	private static final String MSG_KEY_1 = "equals.1";
	private static final String OBJECT_FQN = "java.lang.Object";
	private static final String EQUALS_METH_NAME = "equals";
	private static final String HASHCODE_METH_NAME = "hashCode";

	public String getTestName() {
		return NAME;
	}

	private boolean isHashCodeMethod(IMethodDeclaration node) {
		// check for "public int hashCode()"
		return (HASHCODE_METH_NAME.equals(node.getName())
				&& node.parameters().size() == 0 && Modifier.isPublic(node
				.getModifiers()));
	}

	private boolean isEqualsMethod(IMethodDeclaration node) {
		// check for "public boolean equals(Object obj)"
		return (EQUALS_METH_NAME.equals(node.getName())
				&& node.parameters().size() == 1
				&& OBJECT_FQN.equals(((IVariableDeclaration[]) node
						.parameters().toArray(new IVariableDeclaration[1]))[0]
						.resolveBinding().getType().getName()) && Modifier
				.isPublic(node.getModifiers()));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration)
	 */
	public boolean visit(ITypeDeclaration node) {
		if (node.isInterface() || Modifier.isAbstract(node.getModifiers())) {
			return true;
		}
		IMethodDeclaration[] methods = node.getMethods();
		boolean overridesEquals = false;
		Position equalsPosition = null;
		for (int i = 0; i < methods.length && !overridesEquals; i++) {
			if (isEqualsMethod(methods[i])) {
				overridesEquals = true;
				equalsPosition = methods[i];
			}
		}
		if (!overridesEquals) {
			return true;
		}
		boolean overridesHashCode = false;
		for (int i = 0; i < methods.length && !overridesHashCode; i++) {
			if (isHashCodeMethod(methods[i])) {
				overridesHashCode = true;
			}
		}
		if (!overridesHashCode) {
			addError(MSG_KEY_1, null, equalsPosition);
		}
		return true;
	}

}