/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/language/CloneableTest.java#3 $
 */

package com.sap.tc.jtools.jlint.tests.language;

import java.lang.reflect.Modifier;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;

/**
 * This JLin test checks if classes that implement the empty
 * <code>java.lang.Cloneable</code> interface actually implement a
 * <code>public Object clone()</code> method.
 * 
 * @author d037913
 */
public class CloneableTest extends JomTestVisitor {

	public static final String NAME = "Cloneable Test";

	private static final String MSG_KEY_1 = "clone.1";

	public static final String CLONEABLE_INTF_NAME = "java.lang.Cloneable";
	public static final String CLONE_METH_NAME = "clone";

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.sap.tc.jtools.jlint.jom.JomTestVisitor#getTestName()
	 */
	public String getTestName() {
		return NAME;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration)
	 */
	public boolean visit(ITypeDeclaration node) {
		if (node.isInterface() || Modifier.isAbstract(node.getModifiers()))
			return true;
		IReferenceTypeBinding bnd = (IReferenceTypeBinding) node
				.resolveBinding();
		if (!InheritanceTool.bndImplements(bnd, CLONEABLE_INTF_NAME)) {
			return true;
		}
		// if no non-primitive instance fields are declared and superclass is
		// cloneable, no clone() method is needed
		IFieldDeclaration[] fields = node.getFields();
		boolean hasNonPrimitiveInstanceFields = false;
		for (int i = 0; i < fields.length && !hasNonPrimitiveInstanceFields; i++) {
			ITypeBinding fieldType = fields[i].getType().resolveBinding();
			hasNonPrimitiveInstanceFields = (fieldType.isReference() || fieldType
					.isArray())//arrays are objects!
					&& !Modifier.isStatic(fields[i].getModifiers());
		}
		IReferenceTypeBinding superClass = bnd.getSuperclass();
		if (superClass != null
				&& !hasNonPrimitiveInstanceFields
				&& InheritanceTool.bndImplements(superClass,
						CLONEABLE_INTF_NAME)) {
			return true;
		}
		IMethodDeclaration[] methods = node.getMethods();
		boolean cloneMethodFound = false;
		for (int i = 0; i < methods.length; i++) {
			if (isCloneMethod(methods[i])) {
				cloneMethodFound = true;
				break;
			}
		}
		if (!cloneMethodFound) {
			addCloneMethodError(node);
		}
		return true;
	}
	private void addCloneMethodError(Position pos) {
		addError(MSG_KEY_1, null, pos);
	}

	private static boolean isCloneMethod(IMethodDeclaration declaration) {
		return CLONE_METH_NAME.equals(declaration.getName())
				&& declaration.parameters().size() == 0
				&& Modifier.isPublic(declaration.getModifiers());
	}

}