/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/language/BlockTest.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.language;

import java.util.Properties;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IBreakStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;

/**
 * This JLin test checks if body statements of <code>if, else, for</code>
 * and  <code>while</code> are included in a block. Exceptions are 
 * return, continue, break and throw statements.
 * 
 * If no block is used, readability of the code can be impaired.
 * 
 * @author d037913
 */

public class BlockTest extends JomTestVisitor {

  public static String NAME = "Block Test";

  private static final String MSG_KEY_1 = "block.1";
  private static final String STMT_TYPE_PARAM = "STMT_TYPE";

  public String getTestName() {
    return NAME;
  }

  public boolean visit(IForStatement node) {
    checkIfBlock(node.getBody(), "for");
    return true;
  }

  public boolean visit(IWhileStatement node) {
    checkIfBlock(node.getBody(), "while");
    return true;
  }

  public boolean visit(IIfStatement node) {
    checkIfBlock(node.getThenStatement(), "if");
    IStatement elseStmt = node.getElseStatement();
    if (elseStmt != null) {
      // "else if" without block brackets is OK
      if (!(elseStmt instanceof IIfStatement)) {
        checkIfBlock(node.getElseStatement(), "else");
      }
    }
    return true;
  }

  private void checkIfBlock(IStatement statement, String stmtType) {
    if (!(statement instanceof IBlock)) {
      // single return, continue, break and throw statements are OK
      if (statement instanceof IReturnStatement
        || statement instanceof IThrowStatement
        || statement instanceof IContinueStatement
        || statement instanceof IBreakStatement)
        return;
      addBlockError(stmtType, statement);
    }
  }

  private void addBlockError(String statementType, Position pos) {
    Properties p = new Properties();
    p.setProperty(STMT_TYPE_PARAM, statementType);
    addError(MSG_KEY_1, p, pos);
  }

}
