/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/jarm/JARMInstrumentation.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.jarm;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IStringLiteral;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.Metric;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;

/**
 * @author D037913
 */
public class JARMInstrumentation extends JomMetricVisitor {

  /* keep in sync with tests.xml! */
  private static final String NAME = "JARM Instrumentation";
  private static final String JARM_METRIC = "JARM instrumentation usage";

  private static final String MSG_KEY_1 = "jarm.1";
  private static final String MSG_KEY_2 = "jarm.2";

  private static final String MSG_PAR_COMPONENT_NAME = "JARM_COMPONENT";
  private static final String MSG_PAR_REQ_NAME = "JARM_REQUEST_NAME";

  private static final String MONITOR_INTF =
    "com.sap.util.monitor.jarm.IMonitor";
  private static final String TASK_MONITOR_CLASS =
    "com.sap.util.monitor.jarm.TaskMonitor";
  private static final String METHOD_START_COMP = "startComponent";
  private static final String METHOD_REQ_MON = "getRequestMonitor";

  public String getTestName() {
    return NAME;
  }

  public JARMInstrumentation() {
    super();
  }

  protected MetricInfo[] getMetricInfos() {
    return new MetricInfo[] { new MetricInfo(JARM_METRIC, MetricInfo.SUM) };
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation)
   */
  public boolean visit(IMethodInvocation node) {
    checkJarm(node);
    return true;
  }

  private void checkJarm(IMethodInvocation methInv) {
    IMethodBinding methBnd = methInv.resolveMethodBinding();
    if (!InheritanceTool
      .bndImplements(methBnd.getDeclaringClass(), MONITOR_INTF))
      return;
    addMetricValue(JARM_METRIC, 1, methInv);
    List args = methInv.arguments();
    // check for IMonitor.startComponent(...)
    if (METHOD_START_COMP.equals(methBnd.getName())) {
      for (Iterator iter = args.iterator(); iter.hasNext();) {
        IExpression argExpr = (IExpression) iter.next();
        if (argExpr instanceof IStringLiteral) {
          Properties p = new Properties();
          p.setProperty(
            MSG_PAR_COMPONENT_NAME,
            ((IStringLiteral) argExpr).getLiteralValue());
          addError(MSG_KEY_1, p, methInv);
        }
      }
    }
    // check for TaskMonitor.getRequestMonitorgetRequestMonitor(String userName, String reqName)
    if (InheritanceTool
      .bndExtends(methBnd.getDeclaringClass(), TASK_MONITOR_CLASS)) {
      if (METHOD_REQ_MON.equals(methBnd.getName())) {
        if (args.size() == 2) {
          IExpression argExpr = (IExpression) args.get(1);
          if (argExpr instanceof IStringLiteral) {
            Properties p = new Properties();
            p.setProperty(
              MSG_PAR_REQ_NAME,
              ((IStringLiteral) argExpr).getLiteralValue());
            addError(MSG_KEY_2, p, methInv);
          }
        }
      }
    }
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit)
   */
  public boolean visit(ICompilationUnit node) {
    // add dummy to counter so it gets displayed even if JARM is not used at all
    addMetricValue(JARM_METRIC, 0, node);
    return true;
  }

}
