/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/i18n/StringLiteralTest.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.i18n;

import java.util.Properties;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Commentable;
import com.sap.tc.jtools.jlint.jom.interfaces.IAnonymousClassDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayType;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssertStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssignment;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IBooleanLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IBreakStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ICastExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.ICharacterLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IConditionalExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IDoStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IEmptyStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IImportDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IInfixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IInstanceofExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ILabeledStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.INullLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.INumberLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageName;
import com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IPrefixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.IStringLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchCase;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISynchronizedStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThisExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;

/**
 * This JLin test checks for non-externalized String literals.
 * 
 * In addition to its pseudo-comment $JL-I18N$, it also 
 * supports $NON-NLS-* as pseudo comments for compatibility
 * with eclipse's pseudo-comments.
 * 
 */
public class StringLiteralTest extends JomTestVisitor {

  private static final String ECLIPSE_I18N_PS_CMT = "$NON-NLS-"; //$NON-NLS-1$

  public static final String NAME = "String I18n Test"; //$NON-NLS-1$

  private static final String MSG_KEY_1 = "literal.1";//$NON-NLS-1$
  private static final String LITERAL_PARAM = "LITERAL";//$NON-NLS-1$

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.JomTestVisitor#getTestName()
   */
  public String getTestName() {
    return NAME;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IStringLiteral)
   */
  public boolean visit(IStringLiteral node) {
    if (isDisabled(node))
      return true;
    Properties p = new Properties();
    p.setProperty(LITERAL_PARAM, node.getEscapedValue());
    addError(MSG_KEY_1, p, node);
    return true;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#isDisabledFor(com.sap.tc.jtools.jlint.jom.interfaces.Traversable)
   */
  private boolean isDisabled(Traversable node) {
    if (!(node instanceof Commentable)
      || ((Commentable) node).getEndOfLineComment() == null)
      return false;
    return ((Commentable) node).getEndOfLineComment().getText().indexOf(
      ECLIPSE_I18N_PS_CMT)
      != -1;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IAnonymousClassDeclaration)
   */
  public boolean visit(IAnonymousClassDeclaration node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IArrayAccess)
   */
  public boolean visit(IArrayAccess node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IArrayCreation)
   */
  public boolean visit(IArrayCreation node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IArrayInitializer)
   */
  public boolean visit(IArrayInitializer node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IArrayType)
   */
  public boolean visit(IArrayType node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IAssertStatement)
   */
  public boolean visit(IAssertStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IAssignment)
   */
  public boolean visit(IAssignment node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IBlock)
   */
  public boolean visit(IBlock node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IBooleanLiteral)
   */
  public boolean visit(IBooleanLiteral node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IBreakStatement)
   */
  public boolean visit(IBreakStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ICastExpression)
   */
  public boolean visit(ICastExpression node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause)
   */
  public boolean visit(ICatchClause node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ICharacterLiteral)
   */
  public boolean visit(ICharacterLiteral node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation)
   */
  public boolean visit(IClassInstanceCreation node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit)
   */
  public boolean visit(ICompilationUnit node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IConditionalExpression)
   */
  public boolean visit(IConditionalExpression node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IConstructorInvocation)
   */
  public boolean visit(IConstructorInvocation node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement)
   */
  public boolean visit(IContinueStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IDoStatement)
   */
  public boolean visit(IDoStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IEmptyStatement)
   */
  public boolean visit(IEmptyStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement)
   */
  public boolean visit(IExpressionStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess)
   */
  public boolean visit(IFieldAccess node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration)
   */
  public boolean visit(IFieldDeclaration node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IForStatement)
   */
  public boolean visit(IForStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement)
   */
  public boolean visit(IIfStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IImportDeclaration)
   */
  public boolean visit(IImportDeclaration node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IInfixExpression)
   */
  public boolean visit(IInfixExpression node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IInitializer)
   */
  public boolean visit(IInitializer node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IInstanceofExpression)
   */
  public boolean visit(IInstanceofExpression node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ILabeledStatement)
   */
  public boolean visit(ILabeledStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration)
   */
  public boolean visit(IMethodDeclaration node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation)
   */
  public boolean visit(IMethodInvocation node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.INullLiteral)
   */
  public boolean visit(INullLiteral node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.INumberLiteral)
   */
  public boolean visit(INumberLiteral node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IPackageDeclaration)
   */
  public boolean visit(IPackageDeclaration node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IPackageName)
   */
  public boolean visit(IPackageName node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression)
   */
  public boolean visit(IPostfixExpression node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IPrefixExpression)
   */
  public boolean visit(IPrefixExpression node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName)
   */
  public boolean visit(IQualifiedName node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement)
   */
  public boolean visit(IReturnStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName)
   */
  public boolean visit(ISimpleName node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType)
   */
  public boolean visit(ISimpleType node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation)
   */
  public boolean visit(ISuperConstructorInvocation node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ISuperExpression)
   */
  public boolean visit(ISuperExpression node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation)
   */
  public boolean visit(ISuperMethodInvocation node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ISwitchCase)
   */
  public boolean visit(ISwitchCase node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement)
   */
  public boolean visit(ISwitchStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ISynchronizedStatement)
   */
  public boolean visit(ISynchronizedStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IThisExpression)
   */
  public boolean visit(IThisExpression node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement)
   */
  public boolean visit(IThrowStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement)
   */
  public boolean visit(ITryStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration)
   */
  public boolean visit(ITypeDeclaration node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclarationStatement)
   */
  public boolean visit(ITypeDeclarationStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.ITypeLiteral)
   */
  public boolean visit(ITypeLiteral node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration)
   */
  public boolean visit(IVariableDeclaration node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement)
   */
  public boolean visit(IVariableDeclarationStatement node) {
    return !isDisabled(node);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement)
   */
  public boolean visit(IWhileStatement node) {
    return !isDisabled(node);
  }

}
