/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/gc/StaticCollectionTest.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.gc;

import java.lang.reflect.Modifier;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;

/**
 * @author $Author: p4trans $
 */
public class StaticCollectionTest extends JomTestVisitor {


  private static final String COLLECTION_INTF = "java.util.Collection";//$NON-NLS-1$

  private static final String NAME = "Static Collection Test"; //$NON-NLS-1$
  private static final String MSG_KEY_1 = "collections.1";//$NON-NLS-1$

  private void addStaticCollectionError(Position pos) {
    addError(MSG_KEY_1, null, pos);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.JomTestVisitor#getTestName()
   */
  public String getTestName() {
    return NAME;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration)
   */
  public boolean visit(IFieldDeclaration node) {
    if (!Modifier.isStatic(node.getModifiers()))
      return true;
    ITypeBinding bnd = node.resolveBinding().getType();
    if (bnd instanceof IArrayTypeBinding) {
      bnd = ((IArrayTypeBinding) bnd).getElementType();
    }
    if (bnd instanceof IReferenceTypeBinding) {
      if (InheritanceTool
        .bndImplements((IReferenceTypeBinding) bnd, COLLECTION_INTF)) {
        addStaticCollectionError(node);
      }
    }
    return true;
  }

}
