/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/flow/FlowTest.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.flow;

import com.sap.tc.jtools.jlint.java.flow.BooleanFlowLineMethod;
import com.sap.tc.jtools.jlint.java.flow.FlowLine;
import com.sap.tc.jtools.jlint.java.flow.FlowLineManipulator;
import com.sap.tc.jtools.jlint.jom.JomTestVisitorWithFlow;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;

public class FlowTest extends JomTestVisitorWithFlow
{
 
 	private static final Manipulator manipulator = new Manipulator();
 	private static final BooleanFlowLineMethod checker = new Checker();
 	
 	
	/** keep in sync with tests.xml! */

	private static final String NAME = "Flow Test";

	public String getTestName()
	{
		return NAME;
	}

	/**
	 * 
	 */
	public FlowTest()
	{

	}
	

	public boolean visit(ICompilationUnit node) {
		addFlowLine("type1",new VerySimpleFlowLine());
		return super.visit(node);
	} 
	
	public boolean visit(IMethodDeclaration node) {
		resetFlow("type1");
		addFlowLine("type1",new VerySimpleFlowLine());
		return super.visit(node);
	} 
	
	public void endVisit(IMethodDeclaration node) {
		boolean check = check("type1",checker);
		if (!check) {
			addError("MK",null,node);
		}
	} 




	public boolean visit(IMethodInvocation node) {
		manipulateFlow("type1",manipulator);
		return true;
	}
	
	private static class Manipulator extends FlowLineManipulator {

		public FlowLine[] manipulate(FlowLine fl) {
			VerySimpleFlowLine vsfl = (VerySimpleFlowLine) fl.deepCopy();
			vsfl.setValue(true);
			return new FlowLine[]{vsfl};
		}
		
	}
	
	private static class Checker extends BooleanFlowLineMethod {

		public boolean isTrue(FlowLine fl) {
			return ((VerySimpleFlowLine)fl).isValue();
		}
		
	}
	
	private static class VerySimpleFlowLine implements FlowLine {
		private boolean value = false;
		
		public FlowLine deepCopy() {
			VerySimpleFlowLine copy = new VerySimpleFlowLine();
			copy.value = value;
			return copy;
		}
		
		/**
		 * @return
		 */
		public boolean isValue() {
			return value;
		}

		/**
		 * @param b
		 */
		public void setValue(boolean b) {
			value = b;
		}

	}

	public boolean visitExternal(IIfStatement stmt) {
		return true;
	}

	public void endVisitExternal(IIfStatement stmt) {
		
	}

}
