package com.sap.tc.jtools.jlint.tests.exception;

import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

public class ThrowStatementAnalyser
{
	protected IThrowStatement throwStatement;

	protected String throwTypeName;
	
	protected boolean throwNewExceptionWithEmtpyConstructor;
	
	protected boolean throwNewExceptionWithConstructor;

	protected boolean throwSameException;

	protected boolean throwOtherException;

	protected boolean sameExceptionType;

	protected boolean otherExceptionType;

	protected boolean hasMethodCallWithExceptionParameter;


	public ThrowStatementAnalyser(IThrowStatement throwStatement)
	{
		this.throwStatement = throwStatement;
		
		init();
	}

	protected void init()
	{
		throwTypeName = "";
	}
	
	public void analyse(ExceptionLifecycle exceptionLifecycle)
	{
		if(throwStatement == null)
			throw new NullPointerException("Parameter throwStatement is null");

		if(exceptionLifecycle == null)
			throw new NullPointerException("Parameter exceptionLifecycle is null");


		// IVariableDeclaration catchedException = catchClause.getException();
		String catchedExceptionTypeName = exceptionLifecycle.getExceptionType();  // e.g. java.lang.Exception
		String catchedExceptionName = exceptionLifecycle.getLocalName(); // e.g. myException
		
		IExpression expression =  throwStatement.getExpression();

		if(expression instanceof IClassInstanceCreation)
		{
			IClassInstanceCreation classCreation = (IClassInstanceCreation) expression;

			// empty Constructor
			if(classCreation.arguments().size() == 0)
				throwNewExceptionWithEmtpyConstructor = true;
			else
			{
				throwNewExceptionWithConstructor = true;

				if(JomMethodUtil.checkArguments(classCreation.arguments(), catchedExceptionTypeName) != null)
					sameExceptionType = true;
			}
		}

		if(expression instanceof ISimpleName)
		{
			ISimpleName simpleName = (ISimpleName) expression; 
			String identifier = simpleName.getIdentifier();
					
			// the same exception is thrown forward
			if(identifier.equals(catchedExceptionName) == true)
				throwSameException = true;
						
			ITypeBinding typeBinding = simpleName.resolveTypeBinding();
			if(typeBinding != null) 
			{
				if(typeBinding.getName().equals(catchedExceptionTypeName) == true)
					sameExceptionType = true;
				else
				{
					// the thrown exception is of a new type
					throwOtherException = true;
				}
			}
		}
				
		if(expression instanceof IMethodInvocation)
		{
			IMethodInvocation methodInvocation = (IMethodInvocation) expression; 
			if(JomMethodUtil.checkArguments(methodInvocation.arguments(), catchedExceptionTypeName) != null)
				hasMethodCallWithExceptionParameter = true;
						
			// if return type of MethodInvocation is equal to the
			ITypeBinding returnTypeBinding = methodInvocation.resolveMethodBinding().getReturnType();
			if(returnTypeBinding != null) 
			{
				if(returnTypeBinding.getName().equals(catchedExceptionTypeName) == true)
					sameExceptionType = true;
				else
				{
					// the thrown exception is of a new type
					otherExceptionType = true;
				}
			}
		}
	}
	
	public boolean isCorrect()
	{
		// a correct throw means:
		// a new exception with the nested original exception is thrown or
		// the same exception is thrown forward
		if(throwSameException == true && sameExceptionType == true)
			return true;
			
		if(throwNewExceptionWithConstructor == true)
			return true;		
			
//		if(throwOtherException == true && newExceptionWithConstructor == true)
//			return true;

		// a method has called with the exception as parameter and the method returns an exception
		if(hasMethodCallWithExceptionParameter && (sameExceptionType == true || otherExceptionType == true))
			return true;
		
		return false; 
	}
	
	/**
	 * @return
	 */
	public IThrowStatement getThrowStatement()
	{
		return throwStatement;
	}

	/**
	 * @return
	 */
	public String getThrowTypeName()
	{
		return throwTypeName;
	}

	/**
	 * @param statement
	 */
	public void setThrowStatement(IThrowStatement statement)
	{
		throwStatement = statement;
	}

}
