/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/exception/SAPExceptionTest.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.exception;

import java.util.Properties;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;

/**
 * This class implements a JLin Test concerning the SAP Exception Framework.
 * The test checks whether a thrown exception implements the interface
 * <code>com.sap.exception.IBaseException</code>
 * 
 * @author D039261
 * @author D037913
 */
public class SAPExceptionTest extends JomTestVisitor {

  private static final String MSG_PAR_EXC_NAME = "EXCEPTION_NAME";

  // name of base exception interface
  private static final String BASE_EXCEPTION_INTERFACE = "com.sap.exception.IBaseException"; //$NON-NLS-1$

  /** keep in sync with tests.xml! */
  private static final String NAME = "SAPExceptionTest"; //$NON-NLS-1$

  private static final String MSG_KEY_NOT_FW_EXC = "exceptions.1"; //$NON-NLS-1$

  /**
   * @return name of jlin test
   */
  public String getTestName() {
    return NAME;
  }

  /**
   * Constructor for SAPExceptionTest.
   */
  public SAPExceptionTest() {
    super();
  }

  public boolean visit(IThrowStatement node) {
    checkExceptionType(
      (IReferenceTypeBinding) node.getExpression().resolveTypeBinding(),
      node);
    return true;
  }

  private void checkExceptionType(
    IReferenceTypeBinding binding,
    Position pos) {
    if (!implementsSAPException(binding)) {
      Properties p = new Properties();
      p.setProperty(MSG_PAR_EXC_NAME, binding.getName());
      addError(MSG_KEY_NOT_FW_EXC, p, pos);
    }
  }

  public static boolean implementsSAPException(IReferenceTypeBinding bnd) {
    return InheritanceTool.bndImplements(bnd, BASE_EXCEPTION_INTERFACE);
  }
}