
package com.sap.tc.jtools.jlint.tests.exception;

import java.util.Iterator;
import java.util.List;

import com.sap.tc.jtools.jlint.jom.interfaces.*;

public class JomMethodUtil
{
	private JomMethodUtil()
	{
	}
	
	/**
	 * Checks if a method is called in a list of statements 
	 * @param statements
	 * @param methodName
	 * @param parameterType
	 * @return
	 */
	public static IMethodInvocation checkMethodInvocation(List statements, String methodName, String parameterType, boolean checkArguments)
	{
		if(statements == null || statements.size() == 0)
			return null;
			
		Iterator statementIt = statements.iterator();
		
		while (statementIt.hasNext())
		{
			IStatement statement = (IStatement) statementIt.next();
			
			if(statement instanceof IMethodInvocation)
			{
				if(checkMethodInvocation((IMethodInvocation) statement, methodName, parameterType, checkArguments) == true)
					return (IMethodInvocation) statement;
			}
			else
			{
				if(statement instanceof IExpressionStatement)
				{
					IExpressionStatement expressionStatement = (IExpressionStatement) statement;
					IExpression expression = (IExpression) expressionStatement.getExpression();
					
					if(expression instanceof IMethodInvocation)
					{
						if(checkMethodInvocation((IMethodInvocation) expression, methodName, parameterType, checkArguments) == true)
							return (IMethodInvocation) expression;
					}
				}
				
			}
		}

		return null;		
	}

	/**
	 * Checks if a method is called in a list of statements 
	 * @param statements
	 * @param argumentTypeName
	 * @return
	 */
	public static IMethodInvocation checkMethodInvocationArgument(List statements, String argumentTypeName)
	{
		if(statements == null || statements.size() == 0)
			return null;
			
		Iterator statementIt = statements.iterator();
		
		while (statementIt.hasNext())
		{
			IStatement statement = (IStatement) statementIt.next();
			
			if(statement instanceof IMethodInvocation)
			{
				if(checkMethodInvocationArgument((IMethodInvocation) statement, argumentTypeName) != null)
					return (IMethodInvocation) statement;
			}
			else
			{
				if(statement instanceof IExpressionStatement)
				{
					IExpressionStatement expressionStatement = (IExpressionStatement) statement;
					IExpression expression = (IExpression) expressionStatement.getExpression();
					
					if(expression instanceof IMethodInvocation)
					{
						if(checkMethodInvocationArgument((IMethodInvocation) expression, argumentTypeName) != null)
							return (IMethodInvocation) expression;
					}
				}
				
			}
		}

		return null;		
	}

/*
	public static int analyseThrowStatements(ICatchClause catchClause)
	{
		List statements = catchClause.getBody().statements(); 
		
		if(statements == null || statements.size() == 0)
			return -1;
			
		Iterator statementIt = statements.iterator();
		IVariableDeclaration catchedException = catchClause.getException();
		String catchedExceptionTypeName = catchedException.getType().resolveBinding().getName();
		String catchedExceptionName = catchedException.getName();
		
		while (statementIt.hasNext())
		{
			IStatement statement = (IStatement) statementIt.next();
			
			if(statement instanceof IThrowStatement)
			{
				IThrowStatement throwStatement = (IThrowStatement) statement;
				IExpression expression =  throwStatement.getExpression();

				String node = parseNodeType(expression);			

				if(expression instanceof IClassInstanceCreation)
				{
					IClassInstanceCreation classCreation = (IClassInstanceCreation) expression;

					// empty Constructor
					if(classCreation.arguments().size() == 0)
						return 3;
					
					if(checkArguments(classCreation.arguments(), catchedExceptionTypeName) == true)
						return 2;
				}

				if(expression instanceof ISimpleName)
				{
					ISimpleName simpleName = (ISimpleName) expression; 
					String identifier = simpleName.getIdentifier();
					
					// the same exception is thrown forward
					if(identifier.equals(catchedExceptionName) == true)
						return 1;
				}
			
			
				ITypeBinding typeBinding = throwStatement.getExpression().resolveTypeBinding(); 
				if (!(typeBinding instanceof IReferenceTypeBinding))
				  continue;

				IReferenceTypeBinding xxx = (IReferenceTypeBinding) typeBinding;
				String name = xxx.getName();
				int t = 0; 
			}
		}

		return -1;		

	}
*/
	protected static boolean checkMethodInvocation(IMethodInvocation methodInvocation, String checkMethodName, String parameterType, boolean checkArguments)
	{
//		int nodeType = methodInvocation.getNodeType();
//		String node = parseNodeType(methodInvocation);

		String methodName = methodInvocation.getName();
		
		// check the method invocation itself
		if (methodName.equals(checkMethodName) == true)
		{
			// check if the respective class is the right one
			IReferenceTypeBinding declaringClass = methodInvocation.resolveMethodBinding().getDeclaringClass();
			if(JomBindingUtil.checkExtendsClass(declaringClass, parameterType) == true)
				return true;
		}

		if(checkArguments == false)
			return false;

		List arguments = methodInvocation.arguments();
		Iterator argumentIt = arguments.iterator(); 
		
		// check the arguments			
		while(argumentIt.hasNext())
		{
			IExpression argument = (IExpression) argumentIt.next();

			ITypeBinding argumentType = argument.resolveTypeBinding();
			if (!(argumentType instanceof IReferenceTypeBinding))
			  continue;

			IReferenceTypeBinding argumentBindung = (IReferenceTypeBinding) argumentType;
			
			if(argument instanceof ISimpleName)
			{
				ISimpleName simpleArgument = (ISimpleName) argument;
				
				// retreive the name of the identifier of the argument
				String identifier = simpleArgument.getIdentifier();
				
				if (JomBindingUtil.checkExtendsClass(argumentBindung, parameterType))
				{
					return true;
				}
			}
			else if(argument instanceof IMethodInvocation)
			{
				IMethodInvocation innerMethodInvocation = (IMethodInvocation) argument; 
				String argumentNodeType = parseNodeType(argument);
			
				// check if one of the parameter types extends the parameterType class
				if (JomBindingUtil.checkExtendsClass(argumentBindung, parameterType))
					return true;
					
				String innerMethodName = methodInvocation.getName();

				if (innerMethodName.equals(checkMethodName) == true)
				{
					// check if the respective class is the right one
					boolean extendsClass = JomBindingUtil.checkExtendsClass(methodInvocation.resolveMethodBinding().getDeclaringClass(),
																			parameterType);
					if (extendsClass == true)
						return true;
				}
			}
		}

		return false;
	}


	public static IExpression checkMethodInvocationArgument(IMethodInvocation methodInvocation, String argumentTypeName)
	{
		return checkArguments(methodInvocation.arguments(), argumentTypeName);
	}

	public static IExpression checkArguments(List arguments, String argumentTypeName)
	{
		Iterator argumentIt = arguments.iterator(); 
			
		while(argumentIt.hasNext())
		{
			IExpression argument = (IExpression) argumentIt.next();

			ITypeBinding argumentType = argument.resolveTypeBinding();
			if (!(argumentType instanceof IReferenceTypeBinding))
			  continue;

			IReferenceTypeBinding argumentBindung = (IReferenceTypeBinding) argumentType;
			
			if(argument instanceof ISimpleName)
			{
				ISimpleName simpleArgument = (ISimpleName) argument;
				
				// retreive the name of the identifier of the argument
				String identifier = simpleArgument.getIdentifier();
				
				if (JomBindingUtil.checkExtendsClass(argumentBindung, argumentTypeName))
					return argument;
			}
			else if(argument instanceof IMethodInvocation)
			{
				IMethodInvocation innerMethodInvocation = (IMethodInvocation) argument; 
			
				// check if one of the argument types extends the class argumentTypeName
				if (JomBindingUtil.checkExtendsClass(innerMethodInvocation.resolveMethodBinding().getDeclaringClass(), argumentTypeName))
					return argument;
			}
			else 
			{
				int t = 0;
			}
		}

		return null;
	}

	
	protected static String parseNodeType(Traversable node)
	{
		switch (node.getNodeType()) 
		{
		  case Traversable.ANONYMOUS_CLASS_DECLARATION :
			return ((IAnonymousClassDeclaration) node).getClass().getName();
		  case Traversable.ARRAY_ACCESS :
			return ((IArrayAccess) node).getClass().getName();
		  case Traversable.ARRAY_CREATION :
			return ((IArrayCreation) node).getClass().getName();
		  case Traversable.ARRAY_INITIALIZER :
			return ((IArrayInitializer) node).getClass().getName();
		  case Traversable.ARRAY_TYPE :
			return ((IArrayType) node).getClass().getName();
		  case Traversable.ASSERT_STATEMENT :
			return ((IAssertStatement) node).getClass().getName();
		  case Traversable.ASSIGNMENT :
			return ((IAssignment) node).getClass().getName();
		  case Traversable.BLOCK :
			return ((IBlock) node).getClass().getName();
		  case Traversable.BOOLEAN_LITERAL :
			return ((IBooleanLiteral) node).getClass().getName();
		  case Traversable.BREAK_STATEMENT :
			return ((IBreakStatement) node).getClass().getName();
		  case Traversable.CAST_EXPRESSION :
			return ((ICastExpression) node).getClass().getName();
		  case Traversable.CATCH_CLAUSE :
			return ((ICatchClause) node).getClass().getName();
		  case Traversable.CHARACTER_LITERAL :
			return ((ICharacterLiteral) node).getClass().getName();
		  case Traversable.CLASS_INSTANCE_CREATION :
			return ((IClassInstanceCreation) node).getClass().getName();
		  case Traversable.COMPILATION_UNIT :
			return ((ICompilationUnit) node).getClass().getName();
		  case Traversable.CONDITIONAL_EXPRESSION :
			return ((IConditionalExpression) node).getClass().getName();
		  case Traversable.CONSTRUCTOR_INVOCATION :
			return ((IConstructorInvocation) node).getClass().getName();
		  case Traversable.CONTINUE_STATEMENT :
			return ((IContinueStatement) node).getClass().getName();
		  case Traversable.DO_STATEMENT :
			return ((IDoStatement) node).getClass().getName();
		  case Traversable.EMPTY_STATEMENT :
			return ((IEmptyStatement) node).getClass().getName();
		  case Traversable.EXPRESSION_STATEMENT :
			return ((IExpressionStatement) node).getClass().getName();
		  case Traversable.FIELD_ACCESS :
			return ((IFieldAccess) node).getClass().getName();
		  case Traversable.FIELD_DECLARATION :
			return ((IFieldDeclaration) node).getClass().getName();
		  case Traversable.FOR_STATEMENT :
			return ((IForStatement) node).getClass().getName();
		  case Traversable.IF_STATEMENT :
			return ((IIfStatement) node).getClass().getName();
		  case Traversable.IMPORT_DECLARATION :
			return ((IImportDeclaration) node).getClass().getName();
		  case Traversable.INFIX_EXPRESSION :
			return ((IInfixExpression) node).getClass().getName();
		  case Traversable.INSTANCEOF_EXPRESSION :
			return ((IInstanceofExpression) node).getClass().getName();
		  case Traversable.INITIALIZER :
			return ((IInitializer) node).getClass().getName();
		  case Traversable.LABELED_STATEMENT :
			return ((ILabeledStatement) node).getClass().getName();
		  case Traversable.METHOD_DECLARATION :
			return ((IMethodDeclaration) node).getClass().getName();
		  case Traversable.METHOD_INVOCATION :
			return ((IMethodInvocation) node).getClass().getName();
		  case Traversable.NULL_LITERAL :
			return ((INullLiteral) node).getClass().getName();
		  case Traversable.NUMBER_LITERAL :
			return ((INumberLiteral) node).getClass().getName();
		  case Traversable.PACKAGE_DECLARATION :
			return ((IPackageDeclaration) node).getClass().getName();
		  case Traversable.POSTFIX_EXPRESSION :
			return ((IPostfixExpression) node).getClass().getName();
		  case Traversable.PREFIX_EXPRESSION :
			return ((IPrefixExpression) node).getClass().getName();
		  case Traversable.QUALIFIED_NAME :
			return ((IQualifiedName) node).getClass().getName();
		  case Traversable.RETURN_STATEMENT :
			return ((IReturnStatement) node).getClass().getName();
		  case Traversable.SIMPLE_NAME :
			return ((ISimpleName) node).getClass().getName();
		  case Traversable.SIMPLE_TYPE :
			return ((ISimpleType) node).getClass().getName();
		  case Traversable.STRING_LITERAL :
			return ((IStringLiteral) node).getClass().getName();
		  case Traversable.SUPER_CONSTRUCTOR_INVOCATION :
			return ((ISuperConstructorInvocation) node).getClass().getName();
		  case Traversable.SUPER_EXPRESSION :
			return ((ISuperExpression) node).getClass().getName();
		  case Traversable.SUPER_METHOD_INVOCATION :
			return ((ISuperMethodInvocation) node).getClass().getName();
		  case Traversable.SWITCH_CASE :
			return ((ISwitchCase) node).getClass().getName();
		  case Traversable.SWITCH_STATEMENT :
			return ((ISwitchStatement) node).getClass().getName();
		  case Traversable.SYNCHRONIZED_STATEMENT :
			return ((ISynchronizedStatement) node).getClass().getName();
		  case Traversable.THIS_EXPRESSION :
			return ((IThisExpression) node).getClass().getName();
		  case Traversable.THROW_STATEMENT :
			return ((IThrowStatement) node).getClass().getName();
		  case Traversable.TRY_STATEMENT :
			return ((ITryStatement) node).getClass().getName();
		  case Traversable.TYPE_DECLARATION :
			return ((ITypeDeclaration) node).getClass().getName();
		  case Traversable.TYPE_DECLARATION_STATEMENT :
			return ((ITypeDeclarationStatement) node).getClass().getName();
		  case Traversable.TYPE_LITERAL :
			return ((ITypeLiteral) node).getClass().getName();
		  case Traversable.VARIABLE_DECLARATION :
			return ((IVariableDeclaration) node).getClass().getName();
		  case Traversable.VARIABLE_DECLARATION_STATEMENT :
			return ((IVariableDeclarationStatement) node).getClass().getName();
		  case Traversable.WHILE_STATEMENT :
			return ((IWhileStatement) node).getClass().getName();
		  case Traversable.PACKAGE_NAME :
			return ((IPackageName) node).getClass().getName();
		  default :
		}
		return "";
	}
}
