package com.sap.tc.jtools.jlint.tests.exception;

import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

/**
 * @author C5050508
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class JomBindingUtil
{
	private JomBindingUtil()
	{
	}

	/**
	 * Check the inheritance tree of a type binding
	 * to see if it implements an interface
	 *  
	 * @param bnd the binding to be checked 
	 * @param interfaceName a fully qualified interface name in dot-notation
	 * 
	 * @return true if bnd implements interfaceName
	 */

	public static boolean checkImplementsInterface(
		IReferenceTypeBinding binding,
		String interfaceName)
	{
		if (binding == null || interfaceName == null)
			return false;

		// check all interfaces up the inheritance tree
		IReferenceTypeBinding[] interfaces = null;
		IReferenceTypeBinding curBinding = binding;
		
		while(curBinding != null)
		{
			interfaces = curBinding.getInterfaces();

			if (interfaces != null)
			{
				for (int i = 0; i < interfaces.length; i++)
				{
					if (isInterface(interfaces[i], interfaceName))
						return true;
				}
			}
			
			// check super classes up the inheritance tree
			curBinding = curBinding.getSuperclass();
		}
		
		return false;
	}

	/**
	 * Check the inheritance tree of a type binding
	 * to see if it extends a class
	 *  
	 * @param binding the binding to be checked 
	 * @param superClassName a fully qualified class name in dot-notation
	 * 
	 * @return true if binding implements interfaceName
	 */
	public static boolean checkExtendsClass(
		ITypeBinding binding,
		String superClassName)
	{
		if (binding == null || superClassName == null)
			return false;

		if(!(binding instanceof IReferenceTypeBinding))
			return false;
		
		IReferenceTypeBinding curBinding = (IReferenceTypeBinding) binding;

		while(curBinding != null)
		{
			if (isClass(curBinding, superClassName))
				return true;
				
			// check super classes up the inheritance tree
			curBinding = curBinding.getSuperclass();
		}

		return false;
	}

	public static boolean checkExtendsClassIndirectly(
		IReferenceTypeBinding binding,
		String superClassName)
	{
		if (binding == null || superClassName == null)
			return false;

		IReferenceTypeBinding curBinding = binding;

		while(curBinding != null)
		{
			String name = curBinding.getName();

			if (isClass(curBinding, superClassName))
			{
				if(curBinding == binding)
					return false;

				return true;
			}
				
			// check super classes up the inheritance tree
			curBinding = curBinding.getSuperclass();
		}

		return false;
	}
	
	private static boolean isClass(
		IReferenceTypeBinding binding,
		String className)
	{
		return binding.isClass() && className.equals(getFullClassName(binding));
	}

	private static boolean isInterface(
		IReferenceTypeBinding binding,
		String interfaceName)
	{
		return binding.isInterface() && interfaceName.equals(getFullClassName(binding));
	}

	public static String getFullPackageName(IReferenceTypeBinding binding)
	{
		IPackageBinding packageBinding = binding.getPackage();
		
		if (packageBinding == null)
			return "";
			
		String[] components = packageBinding.getNameComponents();
		StringBuffer buf = new StringBuffer(components.length);
		
		for (int i = 0; i < components.length; i++)
		{
			if(i > 0)
				buf.append(".");
				
			buf.append(components[i]);
		}
		
		return buf.toString();
	}

	/**
	 * convert a String[] to a single String, elements 
	 * separated by a dot "."
	 */
	public static String toDotNotation(String[] components)
	{
		StringBuffer buf = new StringBuffer(components.length);
		
		for (int i = 0; i < components.length; i++)
		{
			if(i > 0)
				buf.append(".");
				
			buf.append(components[i]);
		}
		
		return buf.toString();
	}

	/**
	 * get the fully qualified class name of a binding in
	 * dot-notation.
	 * 
	 * @param bnd the binding
	 * @return the fully qualified class name
	 */
	public static String getFullClassName(ITypeBinding binding)
	{
		return binding.getName();
	}
}
