package com.sap.tc.jtools.jlint.tests.exception;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;

public class ExceptionLifecycleAnalyser
{
	/* the exception lifecyycle to analyse */
	protected ExceptionLifecycle exceptionLifecycle;
	
	/* the original exception of the catch block (catch...) */
	protected IVariableDeclaration originalException;
	
	/* indicates if there is a valid handling method or not */
	boolean handlingMethod = false;
	
	/* indicates if the exception was created by a ClassInstanceCreation with embedding the original exception */
	boolean wrapped = false; 

	/* exceptionReturn */

	List incorrectThrowStatements;
		
	public ExceptionLifecycleAnalyser(ExceptionLifecycle exceptionLifecycle, IVariableDeclaration originalException)
	{
		this.exceptionLifecycle = exceptionLifecycle;
		this.originalException = originalException;
		
		incorrectThrowStatements = new ArrayList();
	}
		
	public void analyse()
	{
		if(exceptionLifecycle == null)
			throw new NullPointerException("Attribute exceptionLifecycle is null");
			
		int exitPointCount = exceptionLifecycle.getExitPointCount();
			
		int methodInvocationsCount = exceptionLifecycle.getMethodInvocationsCount();
		int argumentInvocationsCount = exceptionLifecycle.getArgumentInvocationsCount();
		
		// at least one method was called with the a exception as argument	
		if(argumentInvocationsCount > 0)
			handlingMethod = true;

		// or the exception was created with the original exception embedded in a ClassInstanceCreation
		IExpression expression = exceptionLifecycle.getInitializer();
		if(expression instanceof IClassInstanceCreation)
		{
			IClassInstanceCreation classInstanceCreation = (IClassInstanceCreation) expression;
			IVariableBinding binding = originalException.resolveBinding();
			String typeName = binding.getType().getName();
			if(JomMethodUtil.checkArguments(classInstanceCreation.arguments(), typeName) != null)
				wrapped = true;
		}


		if(exitPointCount > 0)
		{
			// throw, return, expression statement
			Iterator exitPointIt = exceptionLifecycle.getExitPoints().iterator();
			
			while(exitPointIt.hasNext())
			{
				IStatement statement = (IStatement) exitPointIt.next();
				
				if(statement instanceof IThrowStatement)
				{
					// check for correct throw statement
					ThrowStatementAnalyser throwStatementAnalyser = new ThrowStatementAnalyser((IThrowStatement) statement);
					throwStatementAnalyser.analyse(exceptionLifecycle);
					
					if(throwStatementAnalyser.isCorrect() == false) 
						incorrectThrowStatements.add((IThrowStatement) statement);
				}
				else if(statement instanceof IReturnStatement)
				{
					// check for correct return statement
				}
				else if(statement instanceof IExpressionStatement)
				{
					// check for correct return statement
				}
			}
		}
		else
		{
			/*
			// call of e.g.  e.printStackTrace();
			if(methodInvocationsCount > 0)
			{
				// check for too simple methods
				// no throw or return statement -> check handling
				Iterator methodInvocationIt = exceptionLifecycle.getMethodInvocations().iterator();
				int wrongMethodCallCount = 0;			

				// check for method invocations with the exception type as argument
				while(methodInvocationIt.hasNext())
				{
					IExpression expression = (IExpression) methodInvocationIt.next();
					if(expression instanceof IMethodInvocation)
					{
						IMethodInvocation method = (IMethodInvocation) expression; 
					}
				}
			}
				
			// call of System.out.println(e.getMessage());
			Iterator argumentInvocationIt = exceptionLifecycle.getArgumentInvocations().iterator();
				
			while(argumentInvocationIt.hasNext())
			{
				IExpression expression = (IExpression) argumentInvocationIt.next();
				 
				int t = 0;
			}
			*/
		}
	}
	
	public boolean hasHandlingMethod()
	{
		return handlingMethod;
	}
	
	public boolean isWrapped()
	{
		return wrapped;
	}
	
	public List getIncorrectThrowStatements()
	{
		return incorrectThrowStatements;
	}

}
