package com.sap.tc.jtools.jlint.tests.exception;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;

public class ExceptionLifecycle
{
	protected String localName;
	
	protected IBinding binding;

	protected String exceptionType;

	protected Position position;
	
	protected List methodInvocations;
	
	protected List argumentInvocations;
	
	protected List exitPoints;
	
	protected IExpression initializer;
	
	protected static final String NAME_SEPARATOR = "-"; 

	public ExceptionLifecycle(IBinding binding, String exceptionType, IExpression initializer)
	{
		this.initializer = initializer;
		
		this.binding = binding;
		this.localName = binding.getName();
		this.exceptionType = exceptionType;	
		this.position = initializer;
		
		init();
	}

	public ExceptionLifecycle(IBinding binding, IVariableDeclaration declaration)
	{
		this.initializer = null;
		
		this.binding = binding;
		this.localName = binding.getName();
		this.exceptionType = declaration.resolveBinding().getType().getName();	
		this.position = declaration;
		
		init();
	}

	public ExceptionLifecycle(IBinding binding, IVariableDeclarationStatement declarationStatement)
	{
		this.initializer = declarationStatement.getInitializer();
		
		this.binding = binding;
		this.localName = binding.getName();
		this.exceptionType = declarationStatement.resolveBinding().getType().getName();	
		this.position = declarationStatement;
		
		init();
	}
	
	protected void init()
	{
		
		methodInvocations = new ArrayList();
		argumentInvocations = new ArrayList();
		
		exitPoints = new ArrayList();
	}

	public boolean checkCorrectness()
	{
		if(exitPoints.size() > 0)
		{
			// throw or return statement
			Iterator exitPointIt = exitPoints.iterator();
			
			while(exitPointIt.hasNext())
			{
				IStatement statement = (IStatement) exitPointIt.next();
				
				int t = 0;
			}
		}
		else
		{
			// no throw or return statement -> check handling
			Iterator methodInvocationIt = methodInvocations.iterator();
			
			// check for method invocations with the exception type as argument
			while(methodInvocationIt.hasNext())
			{
				IExpression expression = (IExpression) methodInvocationIt.next();
				 
				int t = 0;
			}
			
			Iterator argumentInvocationIt = argumentInvocations.iterator();
			
			while(argumentInvocationIt.hasNext())
			{
				IExpression expression = (IExpression) argumentInvocationIt.next();
				 
				int t = 0;
			}
			
		}
		
		return false;
	}

	public String getId()
	{
		return position.toString();
	}

	public void addAssignment(IExpression expression)
	{
		if(initializer == null)
			initializer = expression;
		else
		{
			if(expression instanceof IClassInstanceCreation)
			{
				// TODO: ???
			}
			else
			{
				methodInvocations.add(expression);
			}
		}
	}

	public void addMethodInvocation(IExpression expression)
	{
		methodInvocations.add(expression);
	}

	public void addArgumentInvocation(IExpression expression)
	{
		argumentInvocations.add(expression);
	}

	public void addExitPoint(IStatement statement)
	{
		exitPoints.add(statement);
	}
	/**
	 * @return
	 */
	public String getExceptionType()
	{
		return exceptionType;
	}

	/**
	 * @return
	 */
	public String getLocalName()
	{
		return localName;
	}

	/**
	 * @param string
	 */
	public void setExceptionType(String string)
	{
		exceptionType = string;
	}

	/**
	 * @param string
	 */
	public void setLocalName(String string)
	{
		localName = string;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		StringBuffer buffer = new StringBuffer();
		
		buffer.append("localName:" + localName + "\n");
		buffer.append("exceptionType:" + exceptionType + "\n");
		buffer.append("position:" + position + "\n");

		buffer.append("initializer: " + initializer + "\n");
		buffer.append("methodInvocations (" + methodInvocations.size() + "):" + methodInvocations + "\n");
		buffer.append("argumentInvocations (" + argumentInvocations.size() + "):" + argumentInvocations + "\n");
		buffer.append("exitPoints (" + exitPoints.size() + "): " + exitPoints + "\n");
		
		return buffer.toString();
	}

	/**
	 * @return
	 */
	public List getExitPoints()
	{
		return exitPoints;
	}

	/**
	 * @return
	 */
	public List getMethodInvocations()
	{
		return methodInvocations;
	}

	/**
	 * @return
	 */
	public List getArgumentInvocations()
	{
		return argumentInvocations;
	}

	public int getThrowExitPointCount()
	{
		int throwExitCount = 0;
		Iterator exitPointIt = exitPoints.iterator();
			
		while(exitPointIt.hasNext())
		{
			IStatement statement = (IStatement) exitPointIt.next();
			if(statement instanceof IThrowStatement)
				throwExitCount++;
		}
		
		return throwExitCount;
	}

	public int getReturnExitPointCount()
	{
		int returnExitCount = 0;
		Iterator exitPointIt = exitPoints.iterator();
			
		while(exitPointIt.hasNext())
		{
			IStatement statement = (IStatement) exitPointIt.next();
			if(statement instanceof IReturnStatement)
				returnExitCount++;
		}
		
		return returnExitCount;	
	}

	public int getExpressionExitPointCount()
	{
		int expressionExitCount = 0;
		Iterator exitPointIt = exitPoints.iterator();
			
		while(exitPointIt.hasNext())
		{
			IStatement statement = (IStatement) exitPointIt.next();
			if(statement instanceof IExpressionStatement)
				expressionExitCount++;
		}
		
		return expressionExitCount;	
	}


	public int getExitPointCount()
	{
		return exitPoints.size();
	}
	
	public int getMethodInvocationsCount()
	{
		return methodInvocations.size();
	}
	
	public int getArgumentInvocationsCount()
	{
		return argumentInvocations.size();
	}

	/**
	 * @return
	 */
	public IExpression getInitializer()
	{
		return initializer;
	}

	/**
	 * @return
	 */
	public IBinding getBinding()
	{
		return binding;
	}

}
