package com.sap.tc.jtools.jlint.tests.exception;

import java.util.HashMap;
import java.util.List;

import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;

public class CatchBlockLifecycle
{
	protected ICatchClause catchClause;
	
	protected HashMap exceptionLifecycleMap;

	protected List simpleMethodInvocations;

	public CatchBlockLifecycle(HashMap exceptionLifecyleMap, List simpleMethodInvocations, ICatchClause catchClause)
	{
		this.exceptionLifecycleMap = exceptionLifecyleMap;
		this.catchClause = catchClause;
		this.simpleMethodInvocations = simpleMethodInvocations;
	}
	
	/**
	 * @return
	 */
	public ICatchClause getCatchClause()
	{
		return catchClause;
	}

	/**
	 * @return
	 */
	public HashMap getExceptionLifecycleMap()
	{
		return exceptionLifecycleMap;
	}

	/**
	 * @return
	 */
	public List getSimpleMethodInvocations()
	{
		return simpleMethodInvocations;
	}

	/**
	 * @param clause
	 */
	public void setCatchClause(ICatchClause clause)
	{
		catchClause = clause;
	}

	/**
	 * @param map
	 */
	public void setExceptionLifecycleMap(HashMap map)
	{
		exceptionLifecycleMap = map;
	}

	/**
	 * @param list
	 */
	public void setSimpleMethodInvocations(List list)
	{
		simpleMethodInvocations = list;
	}

}
