/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/eclipse/api/EclipseAPITest.java#2 $
 */

package com.sap.tc.jtools.jlint.tests.eclipse.api;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.PrimitiveTypeBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayType;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;

/**
 * this JLin test checks if any non-API (i.e. internal) eclipse classes 
 * are used.
 * the package matching pattern for non-API classes 
 * is org.eclipse.*.internal.*
 */

public class EclipseAPITest extends JomTestVisitor {

  /** keep in sync with tests.xml! */

  private static final String NAME = "eclipse API"; //$NON-NLS-1$

  private static final String MSG_KEY_1 = "eclipseapi.1"; //$NON-NLS-1$

  public String getTestName() {
    return NAME;
  }

  /**
   * Constructor for EclipseAPI.
   */
  public EclipseAPITest() {
    super();
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(IQualifiedName)
   */
  public boolean visit(IQualifiedName node) {
    checkPackageBinding(node.resolveTypeBinding(), node);
    return true;
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(IArrayType)
   */
  public boolean visit(IArrayType node) {
    checkPackageBinding(node.resolveBinding(), node);
    return true;
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(ISimpleName)
   */
  public boolean visit(ISimpleName node) {
    checkPackageBinding(node.resolveTypeBinding(), node);
    return true;
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor#visit(ISimpleType)
   */
  public boolean visit(ISimpleType node) {
    checkPackageBinding(node.resolveBinding(), node);
    return true;
  }

  private void checkPackageBinding(ITypeBinding bnd, Position position) {
    if (bnd == null)
      return;
    if (bnd instanceof PrimitiveTypeBinding)
      return;
    if (bnd instanceof ArrayTypeBinding) {
      checkPackageBinding(((ArrayTypeBinding) bnd).getElementType(), position);
      return;
    }
    if (!(bnd instanceof ReferenceTypeBinding)) {
      throw new IllegalArgumentException(
        "unsupported binding type class: " + bnd.getClass().getName());
    }
    IPackageBinding pckBnd = ((ReferenceTypeBinding) bnd).getPackage();
    if (pckBnd == null)
      return;
    String[] packageComp = pckBnd.getNameComponents();
    if (packageComp == null || packageComp.length < 2)
      return;
    if (!packageComp[0].equals("org")) //$NON-NLS-1$
      return;
    if (!packageComp[1].equals("eclipse")) //$NON-NLS-1$
      return;
    // => package starts with "org.eclipse"
    for (int i = 2; i < packageComp.length; i++) {
      if (packageComp[i].equals("internal")) { //$NON-NLS-1$
        // an internal (non-API) package is used
        addError(MSG_KEY_1, null, position);
        break;
      }
    }

  }
}
