/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_tests/src/com/sap/tc/jtools/jlint/tests/XmlRepresentationTest.java#2 $
 */

package com.sap.tc.jtools.jlint.tests;

import java.io.*;
import java.util.*;

import com.sap.tc.jtools.util.structures.*;
import com.sap.tc.jtools.util.xml.*;

import com.sap.tc.jtools.jlint.*;
import com.sap.tc.jtools.jlint.jom.*;

import com.sap.tc.jtools.jlint.jom.interfaces.*;

public class XmlRepresentationTest extends JomTestVisitor {

  static public final String TEST_NAME = "XML representation"; //$NON-NLS-1$
  static public final String JAVA_EXTENSION_JAVA = ".java"; //$NON-NLS-1$
  static public final String JDT_SUFFIX = "_jdt.xml"; //$NON-NLS-1$

  static public final String PARAMETER_OUTPUT_DIRECTORY = "outputDirectory"; //$NON-NLS-1$

  private StructureTree outputTree;
  private Stack currentTree = new Stack();
  /**
   * 
   * Jlin infrastructure
   * 
   */

  public XmlRepresentationTest() {
  }

  public String getTestName() {
    return TEST_NAME;
  }

  /**
   * 
   * End of Jlin infrastructure
   * 
   */

  public void endVisit(IArrayType node) {
    currentTree.pop();
  }
  public void endVisit(ICatchClause node) {
    currentTree.pop();
  }
  public void endVisit(IConstructorInvocation node) {
    currentTree.pop();
  }
  public void endVisit(IExpressionStatement node) {
    currentTree.pop();
  }

  public void endVisit(IPackageDeclaration node) {
    currentTree.pop();
  }

  public void endVisit(ISuperConstructorInvocation node) {
    currentTree.pop();
  }
  public void endVisit(ISuperExpression node) {
    currentTree.pop();
  }
  public void endVisit(ISuperMethodInvocation node) {
    currentTree.pop();
  }
  public void endVisit(IThisExpression node) {
    currentTree.pop();
  }
  public void endVisit(ITypeDeclarationStatement node) {
    currentTree.pop();
  }
  public void endVisit(ITypeLiteral node) {
    currentTree.pop();
  }
  public void endVisit(IVariableDeclaration node) {
    currentTree.pop();
  }
  //	public void endVisit(IVariableDeclarationExpression node) {
  //		currentTree.pop();
  //	}
  public void endVisit(IVariableDeclarationStatement node) {
    currentTree.pop();
  }
  //	public void endVisit(IVariableDeclarationFragment node) {
  //		currentTree.pop();
  //	}
  public void endVisit(IClassInstanceCreation allocationExpression) {
    currentTree.pop();
  }

  public void endVisit(IAnonymousClassDeclaration anonymousTypeDeclaration) {
    currentTree.pop();
  }

  public void endVisit(IArrayCreation arrayAllocationExpression) {
    currentTree.pop();
  }

  public void endVisit(IArrayInitializer arrayInitializer) {
    currentTree.pop();
  }

  public void endVisit(IArrayAccess arrayAccess) {
    currentTree.pop();
  }

  public void endVisit(IAssertStatement assertStatement) {
    currentTree.pop();
  }

  public void endVisit(IAssignment assignment) {
    currentTree.pop();
  }

  public void endVisit(IInfixExpression binaryExpression) {
    currentTree.pop();
  }

  public void endVisit(IBlock block) {
    currentTree.pop();
  }

  public void endVisit(IBreakStatement breakStatement) {
    currentTree.pop();
  }

  public void endVisit(ISwitchCase caseStatement) {
    currentTree.pop();
  }

  public void endVisit(ICastExpression castExpression) {
    currentTree.pop();
  }

  public void endVisit(ICharacterLiteral charLiteral) {
    currentTree.pop();
  }

  public void endVisit(ICompilationUnit compilationUnitDeclaration) {
    String baseDir = this.testObject.getBaseDir();
    String fileName =
      new File(compilationUnitDeclaration.getFileName()).getName();
    File dir =
      new File(
        (String) getParameter(PARAMETER_OUTPUT_DIRECTORY).getValue()
          + File.separator
          + compilationUnitDeclaration.getFileName().substring(
            baseDir.length() + 1,
            compilationUnitDeclaration.getFileName().length()
              - fileName.length()));
    if (!dir.exists()) {
      dir.mkdirs();
    }
    String outputFile =
      (String) getParameter(PARAMETER_OUTPUT_DIRECTORY).getValue()
        + File.separator
        + compilationUnitDeclaration.getFileName().substring(
          baseDir.length() + 1,
          compilationUnitDeclaration.getFileName().length()
            - JAVA_EXTENSION_JAVA.length())
        + JDT_SUFFIX;
    try {
      File f = new File(outputFile);
      XMLTool.writeDocument(outputTree, new FileWriter(f));
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  public void endVisit(IConditionalExpression conditionalExpression) {
    currentTree.pop();
  }

  public void endVisit(IContinueStatement continueStatement) {
    currentTree.pop();
  }

  public void endVisit(IDoStatement doStatement) {
    currentTree.pop();
  }

  public void endVisit(IEmptyStatement statement) {
    currentTree.pop();
  }

  public void endVisit(IFieldDeclaration fieldDeclaration) {
    currentTree.pop();
  }

  public void endVisit(IFieldAccess fieldAccess) {
    currentTree.pop();
  }

  public void endVisit(IForStatement forStatement) {
    currentTree.pop();
  }

  public void endVisit(IIfStatement ifStatement) {
    currentTree.pop();
  }

  public void endVisit(IImportDeclaration importRef) {
    currentTree.pop();
  }

  public void endVisit(IInitializer initializer) {
    currentTree.pop();
  }

  public void endVisit(IInstanceofExpression instanceOfExpression) {
    currentTree.pop();
  }

  public void endVisit(ILabeledStatement labeledStatement) {
    currentTree.pop();
  }

  public void endVisit(INumberLiteral literal) {
    currentTree.pop();
  }

  public void endVisit(IMethodInvocation methodCall) {
    currentTree.pop();
  }

  public void endVisit(IMethodDeclaration methodDeclaration) {
    currentTree.pop();
  }

  public void endVisit(INullLiteral nullLiteral) {
    currentTree.pop();
  }

  public void endVisit(IPostfixExpression postfixExpression) {
    currentTree.pop();
  }

  public void endVisit(IPrefixExpression prefixExpression) {
    currentTree.pop();
  }

  public void endVisit(IQualifiedName qualifiedName) {
    currentTree.pop();

  }

  public void endVisit(IReturnStatement returnStatement) {
    currentTree.pop();
  }

  public void endVisit(ISimpleName name) {
    currentTree.pop();
  }

  public void endVisit(ISimpleType type) {
    currentTree.pop();
  }

  public void endVisit(IStringLiteral stringLiteral) {
    currentTree.pop();

  }

  public void endVisit(ISwitchStatement switchStatement) {
    currentTree.pop();
  }

  public void endVisit(ISynchronizedStatement synchronizedStatement) {

    currentTree.pop();
  }

  public void endVisit(IThrowStatement throwStatement) {
    currentTree.pop();
  }

  public void endVisit(IBooleanLiteral trueLiteral) {
    currentTree.pop();
  }

  public void endVisit(ITryStatement tryStatement) {
    currentTree.pop();
  }

  public void endVisit(ITypeDeclaration typeDeclaration) {
    currentTree.pop();
  }

  public void endVisit(IWhileStatement whileStatement) {
    currentTree.pop();
  }

  public boolean visit(IArrayType node) {
    boolean status = true;
    Header header = new Header("ARRAY_TYPE");
    addLineAndCol(header, node);
    StructureTree tree = new StructureTree(header);
    try {
      ITypeBinding tb = node.resolveBinding();
      header.setParameter("TYPE", getFullName(tb));
      ITypeBinding ct = node.getComponentType();
      header.setParameter("COMPONENT_TYPE", getFullName(ct));
      ITypeBinding et = node.getElementType();
      header.setParameter("ELEMENT_TYPE", getFullName(et));
      header.setParameter("DIMENSIONS", Integer.toString(node.getDimensions()));
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(ICatchClause node) {
    boolean status = true;
    Header header = new Header("CATCH_CLAUSE");
    addLineAndCol(header, node);
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IConstructorInvocation node) {
    boolean status = true;
    Header header = new Header("CONSTRUCTOR_INVOCATION");
    addLineAndCol(header, node);
    ITypeBinding tb = node.resolveConstructorBinding().getDeclaringClass();
    header.setParameter("TYPE", getFullName(tb));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IExpressionStatement node) {
    boolean status = true;
    Header header = new Header("EXPRESSION_STATEMENT");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IPackageDeclaration node) {
    boolean status = true;
    Header header = new Header("PACKAGE_DECLARATION");
    header.setParameter("BINDING_NAME", node.resolveBinding().getName());
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(ISuperConstructorInvocation node) {
    boolean status = true;
    Header header = new Header("SUPER_CONSTRUCTOR_INVOCATION");
    header.setParameter("POSITION", Integer.toString(node.getStartPosition()));
    ITypeBinding tb = node.resolveConstructorBinding().getDeclaringClass();
    header.setParameter("TYPE", getFullName(tb));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(ISuperExpression node) {
    boolean status = true;
    Header header = new Header("SUPER_EXPRESSION");
    ITypeBinding tb = node.resolveTypeBinding();
    header.setParameter("TYPE", getFullName(tb));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(ISuperMethodInvocation node) {
    boolean status = true;
    Header header = new Header("SUPER_METHOD_INVOCATION");
    ITypeBinding tb = node.resolveTypeBinding();
    header.setParameter("TYPE", getFullName(tb));
    header.setParameter("NAME", node.getName());
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IThisExpression node) {
    boolean status = true;
    Header header = new Header("THIS_EXPRESSION");
    ITypeBinding tb = node.resolveTypeBinding();
    header.setParameter("TYPE", getFullName(tb));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(ITypeDeclarationStatement node) {
    boolean status = true;
    Header header = new Header("TYPE_DECLARATION_STATEMENT");
    ITypeBinding tb = node.resolveBinding();
    header.setParameter("TYPE", getFullName(tb));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(ITypeLiteral node) {
    boolean status = true;
    Header header = new Header("TYPE_LITERAL");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IVariableDeclaration node) {
    boolean status = true;
    Header header = new Header("SINGLE_VARIABLE_DECLARATION");
    ITypeBinding tb = node.resolveBinding().getType();
    header.setParameter("TYPE", getFullName(tb));
    header.setParameter("MOdIFIERS", Integer.toString(node.getModifiers()));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IVariableDeclarationStatement node) {
    boolean status = true;
    Header header = new Header("VARIABLE_DECLARATION_STATEMENT");
    header.setParameter("MODIFIERS", Integer.toString(node.getModifiers()));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  /*	public boolean visit(IVariableDeclarationFragment node) {
  		boolean status = true;
  		Header header = new Header("VARIABLE_DECLARATION_FRAGMENT");
  		IVariableBinding vb = node.resolveBinding();
  		if (vb == null)
  			header.setParameter("TYPE", "_unknown_type_");
  		else
  			header.setParameter("TYPE", getFullName(vb.getType()));
  		int extraDims = node.getExtraDimensions();
  		if (extraDims != 0)
  			header.setParameter("EXTRA_DIMS", Integer.toString(extraDims));
  		StructureTree tree = new StructureTree(header);
  		((StructureTree) currentTree.peek()).addNewChild(tree);
  		currentTree.push(tree);
  		return status;
  	}
  */
  public boolean visit(IClassInstanceCreation allocationExpression) {
    boolean status = true;
    Header header = new Header("CLASS_INSTANCE_CREATION");
    addLineAndCol(header, allocationExpression);
    StructureTree tree = new StructureTree(header);
    try {
      ITypeBinding tb = allocationExpression.resolveTypeBinding();
      header.setParameter("TYPE", getFullName(tb));
      IMethodBinding mb = allocationExpression.resolveConstructorBinding();
      ITypeBinding tbc = null;
      if (mb != null)
        tbc = mb.getDeclaringClass();
      header.setParameter("CONSTRUCTOR_TYPE", getFullName(tbc));
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IAnonymousClassDeclaration node) {
    boolean status = true;
    Header header = new Header("ANONYMOUS_CLASS_DECLARATION");
    addLineAndCol(header, node);
    StructureTree tree = new StructureTree(header);
    try {
      IReferenceTypeBinding tb = (IReferenceTypeBinding) node.resolveBinding();

      if (tb != null) {
        header.setParameter("TYPE", getFullName(tb));
        IReferenceTypeBinding tbsuper = tb.getSuperclass();
        if (tbsuper.isClass())
          header.setParameter("SUPERCLASS", getFullName(tbsuper));
        else
          header.setParameter("SUPERINTERFACE", getFullName(tbsuper));
      } else {
        header.setParameter("SUPERTYPE", getFullName(null));
      }
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IArrayCreation arrayAllocationExpression) {
    boolean status = true;
    Header header = new Header("ARRAY_CREATION");
    addLineAndCol(header, arrayAllocationExpression);
    StructureTree tree = new StructureTree(header);
    try {
      ITypeBinding tb = arrayAllocationExpression.resolveTypeBinding();
      header.setParameter("TYPE", getFullName(tb));
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }

    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IArrayInitializer arrayInitializer) {
    boolean status = true;
    Header header = new Header("ARRAY_INITIALIZER");
    addLineAndCol(header, arrayInitializer);
    StructureTree tree = new StructureTree(header);
    try {
      ITypeBinding tb = arrayInitializer.resolveTypeBinding();
      header.setParameter("TYPE", getFullName(tb));
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }

    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IArrayAccess arrayAccess) {
    boolean status = true;
    Header header = new Header("ARRAY_ACCESS");
    addLineAndCol(header, arrayAccess);
    ITypeBinding tb = arrayAccess.resolveTypeBinding();
    header.setParameter("TYPE", getFullName(tb));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IAssertStatement assertStatement) {
    boolean status = true;
    Header header = new Header("ASSERT");
    addLineAndCol(header, assertStatement);
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IAssignment assignment) {

    Header header = new Header("ASSIGNMENT");
    addLineAndCol(header, assignment);
    header.setParameter("OPERATOR", assignment.getOperator());
    ITypeBinding tb = assignment.resolveTypeBinding();
    header.setParameter("TYPE", getFullName(tb));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);

    return true;
  }

  public boolean visit(IInfixExpression binaryExpression) {
    boolean status = true;
    Header header = new Header("INFIX_EXPRESSION");
    header.setParameter("OPERATOR", binaryExpression.getOperator());
    StructureTree tree = new StructureTree(header);
    try {
      ITypeBinding tb = binaryExpression.resolveTypeBinding();
      header.setParameter("TYPE", getFullName(tb));
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;

  }

  public boolean visit(IBlock block) {
    Header header = new Header("BLOCK");
    addLineAndCol(header, block);
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(IBreakStatement breakStatement) {

    Header header = new Header("BREAK");
    addLineAndCol(header, breakStatement);
    if (breakStatement.getLabel() != null)
      header.setParameter("LABEL", breakStatement.getLabel());
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(ISwitchCase caseStatement) {
    Header header = new Header("SWITCH_CASE");
    if (caseStatement.isDefault())
      header.setParameter("DEFAULT", "true");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);

    return true;
  }

  public boolean visit(ICastExpression castExpression) {
    boolean status = true;
    Header header = new Header("CAST_EXPRESSION");
    addLineAndCol(header, castExpression);
    StructureTree tree = new StructureTree(header);
    try {
      ITypeBinding tb = castExpression.resolveTypeBinding();
      header.setParameter("TYPE", getFullName(tb));
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(ICharacterLiteral charLiteral) {
    Header header = new Header("CHARACTER_LITERAL");
    addLineAndCol(header, charLiteral);
    StructureTree tree = new StructureTree(header);
    ITypeBinding tb = charLiteral.resolveTypeBinding();
    header.setParameter("TYPE", getFullName(tb));
    header.setParameter(
      "CHAR_VALUE",
      new String(new char[] { charLiteral.charValue()}));
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(ICompilationUnit compilationUnitDeclaration) {
    currentCompilationUnit = compilationUnitDeclaration;
    Header header = new Header("COMPILATION_UNIT");
    addLineAndCol(header, compilationUnitDeclaration);
    header.setParameter("FILE", compilationUnitDeclaration.getFileName());
    outputTree = new StructureTree(header);
    currentTree.push(outputTree);
    return true;
  }

  public boolean visit(IConditionalExpression conditionalExpression) {
    Header header = new Header("CONDITIONAL_EXPRESSION");
    addLineAndCol(header, conditionalExpression);
    ITypeBinding tb = conditionalExpression.resolveTypeBinding();
    header.setParameter("TYPE", getFullName(tb));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(IContinueStatement continueStatement) {
    Header header = new Header("CONTINUE");
    if (continueStatement.getLabel() != null)
      header.setParameter("LABEL", continueStatement.getLabel());
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);

    return true;
  }

  public boolean visit(IDoStatement doStatement) {
    Header header = new Header("DO_STMT");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(IEmptyStatement statement) {
    Header header = new Header("EMPTY_STMT");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(IFieldDeclaration fieldDeclaration) {

    boolean status = true;
    Header header = new Header("FIELD_DECLARATION");
    StructureTree tree = new StructureTree(header);
    try {
      header.setParameter(
        "MODIFIERS",
        Integer.toString(fieldDeclaration.getModifiers()));
      ITypeBinding tb = fieldDeclaration.getType().resolveBinding();
      header.setParameter("TYPE", getFullName(tb));
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;

  }

  public boolean visit(IFieldAccess fieldAccess) {
    boolean status = true;
    Header header = new Header("FIELD_ACCESS");
    StructureTree tree = new StructureTree(header);
    try {
      ITypeBinding tb = fieldAccess.resolveTypeBinding();
      header.setParameter("TYPE", getFullName(tb));
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IForStatement forStatement) {
    Header header = new Header("FOR_STATEMENT");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  /**
   * @see org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor#visit(IfStatement, BlockScope)
   */
  public boolean visit(IIfStatement ifStatement) {
    Header header = new Header("IF_STATEMENT");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(IImportDeclaration importRef) {
    Header header = new Header("IMPORT_DECLARATION");
    IBinding binding = (IBinding) importRef.resolveBinding();
    if (binding == null)
      header.setParameter("BINDING", "_unknown_type_");
    else {
      if (binding instanceof IPackageBinding)
        header.setParameter("BINDING", binding.getName());
      if (binding instanceof ITypeBinding)
        header.setParameter("BINDING", getFullName((ITypeBinding) binding));
    }
    if (importRef.isOnDemand())
      header.setParameter("ON_DEMAND", "true");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(IInitializer initializer) {
    Header header = new Header("INITIALIZER");
    header.setParameter(
      "MODIFIERS",
      Integer.toString(initializer.getModifiers()));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  /**
   * @see org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor#visit(InstanceOfExpression, BlockScope)
   */
  public boolean visit(IInstanceofExpression instanceOfExpression) {
    Header header = new Header("INSTANCE_OF");
    ITypeBinding tb = instanceOfExpression.resolveTypeBinding();
    header.setParameter("TYPE", getFullName(tb));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(INumberLiteral literal) {
    Header header = new Header("NUMBER__LITERAL");
    header.setParameter("VALUE", literal.getToken());
    ITypeBinding tb = literal.resolveTypeBinding();
    header.setParameter("TYPE", getFullName(tb));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(ILabeledStatement labeledStatement) {
    Header header = new Header("LABELED_STMT");
    header.setParameter("LABEL", labeledStatement.getLabel());
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);

    return true;
  }

  public boolean visit(IMethodInvocation methodCall) {

    boolean status = true;

    Header header = new Header("METHOD_INVOCATION");
    StructureTree tree = new StructureTree(header);
    try {
      ITypeBinding tb = methodCall.resolveTypeBinding();

      header.setParameter("TYPE", getFullName(tb));
      header.setParameter("METHOD_NAME", methodCall.getName());

    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;

  }

  public boolean visit(IMethodDeclaration methodDeclaration) {

    boolean status = true;
    String methodOrConstructor =
      methodDeclaration.isConstructor()
        ? "CONSTRUCTOR_DECLARATION"
        : "METHOD_DECLARATION";
    Header header = new Header(methodOrConstructor);
    header.setParameter(
      "MODIFIERS",
      Integer.toString(methodDeclaration.getModifiers()));
    StructureTree tree = new StructureTree(header);
    try {
      header.setParameter("NAME", methodDeclaration.getName());
      if (!methodDeclaration.isConstructor()) {
        ITypeBinding tb = methodDeclaration.getReturnType().resolveBinding();
        header.setParameter("RETURN_TYPE", getFullName(tb));
      }
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(INullLiteral nullLiteral) {
    Header header = new Header("NULL_LITERAL");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);

    return true;
  }

  public boolean visit(IPostfixExpression postfixExpression) {
    Header header = new Header("POSTFIX_EXPRESSION");
    header.setParameter("OPERATOR", postfixExpression.getOperator());
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);

    return true;
  }

  public boolean visit(IPrefixExpression prefixExpression) {
    Header header = new Header("PREFIX_EXPRESSION");
    header.setParameter("OPERATOR", prefixExpression.getOperator());
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);

    return true;
  }

  public boolean visit(IQualifiedName qualifiedName) {

    boolean status = true;
    Header header = new Header("QUALIFIED_NAME");
    StructureTree tree = new StructureTree(header);

    try {
      ITypeBinding tb = qualifiedName.resolveTypeBinding();
      header.setParameter("TYPE", getFullName(tb));
      StructureTree cTree = tree;
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(IReturnStatement returnStatement) {
    Header header = new Header("RETURN_STATEMENT");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);

    return true;
  }

  public boolean visit(ISimpleName name) {

    boolean status = true;

    Header header = new Header("SIMPLE_NAME");
    StructureTree tree = new StructureTree(header);
    try {
      ITypeBinding tb = name.resolveTypeBinding();
      header.setParameter("IDENTIFIER", name.getIdentifier());
      header.setParameter("TYPE", getFullName(tb));
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;
  }

  public boolean visit(ISimpleType type) {

    boolean status = true;

    Header header = new Header("SIMPLE_TYPE");
    StructureTree tree = new StructureTree(header);
    try {
      ITypeBinding tb = type.resolveBinding();
      header.setParameter("TYPE", getFullName(tb));
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;

  }

  public boolean visit(IStringLiteral stringLiteral) {

    boolean status = true;
    //        String value = stringLiteral.toStringExpression().substring(1,stringLiteral.toStringExpression().length()-1);

    Header header = new Header("STRING_LITERAL");
    StructureTree tree = new StructureTree(header);

    header.setParameter("LITERAL_VALUE", stringLiteral.getLiteralValue());
    ITypeBinding tb = stringLiteral.resolveTypeBinding();
    header.setParameter("TYPE", getFullName(tb));
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;

  }

  public boolean visit(ISwitchStatement switchStatement) {

    Header header = new Header("SWITCH_STATEMENT");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(ISynchronizedStatement synchronizedStatement) {

    Header header = new Header("SYNCHRONIZED_STATEMENT");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(IThrowStatement throwStatement) {
    Header header = new Header("THROW_STMT");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);

    return true;
  }

  public boolean visit(IBooleanLiteral literal) {
    Header header = new Header("BOOLEAN_LITERAL");
    addLineAndCol(header, literal);
    header.setParameter("VALUE", String.valueOf(literal.booleanValue()));
    ITypeBinding tb = literal.resolveTypeBinding();
    header.setParameter("TYPE", getFullName(tb));
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public boolean visit(ITryStatement tryStatement) {
    Header header = new Header("TRY_STMT");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);

    return true;
  }

  public boolean visit(ITypeDeclaration typeDeclaration) {
    boolean status = true;

    Header header = new Header("TYPE_DECLARATION");
    if (typeDeclaration.isInterface())
      header.setParameter("IS_INTERFACE", "true");
    if (typeDeclaration.isPackageMemberTypeDeclaration())
      header.setParameter("IS_PACKAGE_MEMBER_TYPE_DECL", "true");
    if (typeDeclaration.isMemberTypeDeclaration())
      header.setParameter("IS_MEMBER_TYPE_DECL", "true");
    if (typeDeclaration.isLocalTypeDeclaration())
      header.setParameter("IS_LOCAL_TYPE_DECL", "true");
    header.setParameter(
      "MODIFIERS",
      Integer.toString(typeDeclaration.getModifiers()));
    StructureTree tree = new StructureTree(header);
    try {
      ITypeBinding tb = typeDeclaration.resolveBinding();
      header.setParameter("TYPE", getFullName(tb));
    } catch (Exception e) {
      writeError(e, tree);
      status = false;
    }
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return status;

  }

  public boolean visit(IWhileStatement whileStatement) {
    Header header = new Header("WHILE_STATEMENT");
    StructureTree tree = new StructureTree(header);
    ((StructureTree) currentTree.peek()).addNewChild(tree);
    currentTree.push(tree);
    return true;
  }

  public void writeError(Exception e, StructureTree tree) {
    logException(e);
  }

  private String getFullName(ITypeBinding tb) {
    if (tb == null)
      return "_unknown type_";
    return tb.getName();

  }

  private void addLineAndCol(Header header, Position pos) {
    header.setParameter(
      "LINE",
      String.valueOf(
        currentCompilationUnit.lineNumber(pos.getStartPosition())));
    /*    header.setParameter(
          "COLUMN",
          String.valueOf(
            currentCompilationUnit.columnNumber(pos.getStartPosition())));*/
  }

}
